<?php
namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\I18n\Time;
use CodeIgniter\HTTP\UserAgent;
use CodeIgniter\Files\File;

use Psr\Log\LoggerInterface;

use Store\DataHelper;
use StoreApp\DataAppHelper;
use Constant\ConstantHelper;

use App\Models\BaseModel;

abstract class BaseController extends Controller {

	/**
  * Instance of the main Request object.
  *
  * @var CLIRequest|IncomingRequest
  */

	protected $request;

	/**
  * An array of helpers to be loaded automatically upon
  * class instantiation. These helpers will be available
  * to all other controllers that extend BaseController.
  *
  * @var array
  */

	protected $helpers = ['form', 'date', 'html', 'number', 'text', 'filesystem'];

	/*
	* Constructor.
	*/

	protected $appGlobalData = [];

	protected $baseModel 				= null;
	protected $dataHelper				= null;
	protected $dataAppHelper		= null;
	protected $constantHelper		= null;

	public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger) {
		parent::initController($request, $response, $logger);

		$this->baseModel 			= new BaseModel;
		$this->dataHelper 		= new DataHelper;
		$this->dataAppHelper	= new DataAppHelper;
		$this->constantHelper = new ConstantHelper;
		
		$this->appGlobalData 	= $this->dataAppHelper->DAH_loadAppGlobalData();

		ini_set('memory_limit', '64M');
	}

	protected function _app($view, $dados = array(), $manutencao = true) {
		$dados = array_merge($this->appGlobalData, $dados);
		$token = service('session')->get('token_homologacao');

		if(isset($this->appGlobalData['appInstitucionalDados']->redirecionamento) AND !empty($this->appGlobalData['appInstitucionalDados']->redirecionamento)) {
			header("Location: " . $this->appGlobalData['appInstitucionalDados']->redirecionamento);
			die();
		}

		if($this->appGlobalData['appInstitucionalDados']->ativo == 0 AND empty($token) AND $manutencao) {
			echo view('Views\view_manutencao', $dados);
		}
		else {
			echo view('Views\view_topo', $dados);

			if (is_array($view)) {
				foreach ($view as $valor) {
					echo view($valor, $dados);
				}
			} 
			else {
				echo view($view, $dados);
			}

			echo view('view_rodape', $dados);
		}
	}

	protected function _social($view, $dados = array()) {
		$dados = array_merge($this->appGlobalData, $dados);
		echo view($view, $dados);
	}
}
