<?php
namespace Modules\Blog\Controllers;

use App\Controllers\BaseController;
use Modules\Blog\Models\model_blog;

use Core\MY_Controller;
use Store\DataHelper;

class Blog extends BaseController {
	public function __construct() {
		$this->dataHelper	= new DataHelper;
		$this->model_blog = new Model_blog; 
	}

	public function index($tipo = null, $urlAmigavel = null) {
		$totalListagem 	= 12;
		$pagina 				= service('request')->getGet('pagina');
		$pagina 				= !empty($pagina) ? $pagina - 1 : 0;

		$dados['banners']			= $this->model_blog->getBanners('blog');
		$dados['categorias']	= $this->model_blog->getCategorias();
		$dados['blogs']				= $this->model_blog->getBlogs($pagina, $totalListagem, $tipo, $urlAmigavel);

		if(isset($tipo) AND !empty($tipo) AND $tipo == "categoria") {
			$dados['categoria'] = $this->model_blog->getCategoria($urlAmigavel);
			$dados['categoriaPaginacao'] = '/categoria/' . $urlAmigavel;
		}
		else {
				$dados['categoriaPaginacao'] = '';
		}

		$totalPaginas 		= ceil($dados['blogs']['total'] / $totalListagem);
		$paginasRestantes = $totalPaginas - $pagina;

		$dados['paginaAtual'] 		 = $pagina;
		$dados['paginasRestantes'] = $paginasRestantes;

		$this->_app('Modules\Blog\Views\view_blog', $dados);
	}

	public function detalhes($urlAmigavel) {
		$dados['categorias']				= $this->model_blog->getCategorias();
		$dados['blog']							= $this->model_blog->getBlog($urlAmigavel);

		$this->_app('Modules\Blog\Views\view_blog_detalhes', $dados);
	}

	public function error_404() {
		$this->_app('Modules\Blog\Views\view_404');
	}
}