<?php
namespace Modules\Blog\Models;
use App\Models\BaseModel;

class Model_blog extends BaseModel {
	public function getBanners($modulo) {
		$table 		= 'cad_banner_categorias';
		$builder 	= $this->db->table($table);
		
		$builder->select('*');
		$builder->where('modulo', $modulo);

		$query = $builder->get();

		$categoria = $query->getRow();

		if(isset($categoria) AND !empty($categoria)) {
			$table 		= 'cad_banner';
			$builder 	= $this->db->table($table);

			$builder->select('cad_banner.*');
			$builder->join('cad_banner_categorias', 'cad_banner_categorias.id = ' . $table . '.id_categoria', 'inner');
			$builder->where('cad_banner.id_categoria', $categoria->id);
			$builder->where('cad_banner.ativo', 1);

			$query = $builder->get();

			return $query->getResult();
		}
	}

	public function getCategorias() {
		$table 		= 'cad_blog_categorias';
		$builder 	= $this->db->table($table);
		
		$builder->select('*');
		$builder->where('ativo', 1);
		$builder->orderBy('titulo', 'asc');

		$query 			= $builder->get();
		$categorias = $query->getResult();

		return $categorias;
	}

	public function getCategoria($urlAmigavel) {
		$table      = 'cad_blog_categorias';
		$builder    = $this->db->table($table);

		$builder->where($table . '.url_amigavel', $urlAmigavel);

		$query      = $builder->get();
		$categoria	= $query->getRow();

		return $categoria;
	}

	public function getBlogs($pagina, $totalListagem, $tipo = null, $urlAmigavel = null, $id_produto_excluir = null) {
		if (!empty($tipo) AND $tipo == 'categoria') {
			$table      = 'cad_blog_categorias';
			$builder    = $this->db->table($table);

			$builder->select('*');
			$builder->where('url_amigavel', $urlAmigavel);

			$query		 = $builder->get();
			$categoria = $query->getRow();
		}

		$table      	= 'cad_blog';
		$builder    	= $this->db->table($table);

		$builder->select($table . '.*, cad_blog_categorias.titulo AS categoria');
		$builder->join('cad_blog_categorias', 'cad_blog_categorias.id = ' . $table . '.id_categoria', 'inner');

		if(isset($categoria) AND !empty($categoria)) {
			$builder->where($table . '.id_categoria', $categoria->id);
			$totalRecords = $this->db->table($table)->where($table . '.id_categoria', $categoria->id)->countAllResults();
		}
		else {
			$builder->where($table . '.destaque', 1);
			$totalRecords = $this->db->table($table)->where($table . '.destaque', 1)->countAllResults();
		}

		if (!empty($id_produto_excluir)) {
			$builder->where('id <>', $id_produto_excluir);
		}

		$builder->orderBy('data', 'desc');
		$builder->limit($totalListagem);

		if (!empty($pagina)) {
			$atual = ($pagina * $totalListagem);
			$builder->offset($atual);
		}

		$query						 = $builder->get();
		$blog['cadastros'] = $query->getResult();
		$blog['total'] 		 = $totalRecords;

		return $blog;
	}

	public function getBlog($urlAmigavel) {
		$table      = 'cad_blog';
		$builder    = $this->db->table($table);

		$builder->select($table . '.*, cad_blog_categorias.titulo AS categoria');
		$builder->join('cad_blog_categorias', 'cad_blog_categorias.id = ' . $table . '.id_categoria', 'inner');
		$builder->where($table . '.url_amigavel', $urlAmigavel);

		$query      = $builder->get();
		$blog    		= $query->getRow();

		return $blog;
	}

}