<?php
namespace Modules\Inicial\Controllers;

use App\Controllers\BaseController;
use Modules\Inicial\Models\model_inicial;

use Store\DataHelper;
use StoreApp\DataAppHelper;

class Inicial extends BaseController {
	public function __construct() {
		$this->dataHelper    	= new DataHelper;
		$this->dataAppHelper	= new DataAppHelper;
		$this->model_inicial 	= new Model_inicial; 
	}

	public function index() {
		$dados['banners'] 	= $this->dataAppHelper->DAH_appGetBanners('inicial');
		$dados['galerias'] 	= $this->dataAppHelper->DAH_appGetGalerias();
		$dados['blogs'] 		= $this->dataAppHelper->DAH_appGetBlogs();
		$dados['marcas'] 		= $this->dataAppHelper->DAH_appGetMarcas();

		$this->_app('Modules\Inicial\Views\view_inicial', $dados);
	}

	public function politica() {
		$this->_app('Modules\Inicial\Views\view_politica');
	}

	public function homologacao($token) {
		$consulta = $this->model_inicial->homologacaoVerificador();
		return redirect()->to(site_url());
	}

	public function producao() {
		service('session')->remove('token_homologacao');
		return redirect()->to(site_url());
	}

	public function error_404() {
		$this->_app('Modules\Inicial\Views\view_404');
	}
}