<!DOCTYPE html>
<html lang="pt-br" class="side-panel sticky-header-reveal no-safari-overflow-x-fix <?php echo $appUri1; ?> <?php echo $appUri2; ?> <?php echo $appUri3; ?> <?php echo $appUri4; ?>">

<head>

	<!-- 
	---- Pixels ::: Head top
	--->

	<?php 
	foreach($appPixel as $key => $valor) {
		if($valor->posicao == 'head_top') {
			echo $valor->codigo;
		}
	} 
	?>

	<!--
	---- Basic
	--->

	<?php echo view('Views\view_topo_seo'); ?>
	<?php echo view('Views\view_topo_assets'); ?>

	<!-- 
	---- Pixels ::: Head bottom
	--->

	<?php 
	foreach($appPixel as $key => $valor) {
		if($valor->posicao == 'head_bottom') {
			echo $valor->codigo;
		}
	} 
	?>
</head>

<body data-plugin-page-transition class="loading-overlay-showing" data-loading-overlay data-plugin-options="{'hideDelay': 500}" class="position-relative"> 

	<!-- 
	---- Pixels ::: Body top
	--->

	<?php 
	foreach($appPixel as $key => $valor) {
		if($valor->posicao == 'body_top') {
			echo $valor->codigo;
		}
	} 
	?>

	<div class="loading-overlay">
		<div class="bounce-loader">
			<div class="bounce1"></div>
			<div class="bounce2"></div>
			<div class="bounce3"></div>
		</div>
	</div>

	<!-- 
	---- Logo ::: Sizes
	--->

	<?php  
	$logoWidth 	= 125;
	$logoHeight = 29.83;

	$stickyWidth	= $logoWidth * 0.7;  
	$stickyHeight = $logoHeight * 0.7;
	?>

	<div class="body">
		<header id="header" class="d-none d-lg-flex header-effect-shrink" data-plugin-options="{'stickyEnabled': true, 'stickyEffect': 'shrink', 'stickyEnableOnBoxed': true, 'stickyEnableOnMobile': false, 'stickyChangeLogo': true, 'stickyStartAt': 30, 'stickyHeaderContainerHeight': 70}">
			<div class="header-body border-0 bg-app-custom-color-pri">
				<div class="header-container container">
					<div class="header-row">
						<div class="header-nav justify-content-center position-relative">
							<div class="header-nav-main">
								<div class="header-logo">
									<a href="<?php echo BASEURL; ?>">
										<img width="<?php echo $logoWidth; ?>" height="<?php echo $logoHeight; ?>" data-sticky-width="<?php echo $stickyWidth; ?>" data-sticky-height="<?php echo $stickyHeight; ?>" src="<?php echo PUBLICURL . 'uploads/upload_cad_institucional/' . $appInstitucionalDados->imagem; ?>" alt="<?php echo $appInstitucionalDados->titulo; ?>" alt="<?php echo $appInstitucionalDados->titulo; ?>" class="img-fluid">
									</a>
								</div>

								<nav class="collapse">
									<ul class="nav nav-pills" id="mainNav">
										<li class="m-0">
											<a class="text-custom-white rounded-5" href="<?php echo BASEURL; ?>">
												Home
											</a>
										</li>

										<li class="m-0">
											<a class="text-custom-white rounded-5" href="<?php echo BASEURL . 'quem-somos'; ?>">
												Quem somos
											</a>
										</li>

										<li class="dropdown m-0">
											<a class="dropdown-item dropdown-toggle pointer-event text-custom-white rounded-5" href="#">
												Galeria de fotos
											</a>

											<ul class="dropdown-menu bg-app-custom-color-pri border-0">
												<?php foreach ($appGalerias as $key => $galeria) { ?>
													<li>
														<a class="dropdown-item text-white" href="<?php echo BASEURL . 'galeria-de-fotos/' . $galeria->url_amigavel; ?>">
															<?php echo $galeria->titulo; ?>
														</a>
													</li>
												<?php } ?>
											</ul>
										</li>

										<li class="m-0">
											<a class="text-custom-white rounded-5" href="<?php echo BASEURL . 'blog'; ?>">
												Blog
											</a>
										</li>

										<li class="m-0">
											<a class="text-custom-white rounded-5" download href="<?php echo PUBLICURL . 'uploads/upload_cad_blocos/' . $appBlocos->bloco4_arquivo; ?>">
												<?php echo $appBlocos->bloco4_titulo; ?>
											</a>
										</li>

										<li class="m-0">
											<a class="text-custom-white rounded-5" href="<?php echo BASEURL . 'contato'; ?>">
												Contato
											</a>
										</li>
									</ul>
								</nav>

								<div class="header-buttons">
									<a class="btn-app-custom-pri text-uppercase rounded-5" href="<?php echo BASEURL . 'faca-um-orcamento'; ?>">
										Efetue um orçamento
									</a>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</header>

		<!-- ---------------------------------------------------------------------------------------------------------- -->

		<header id="header-mobile" class="d-flex d-lg-none border-0 bg-app-custom-color-pri">
			<div class="container py-4">
				<div class="row">
					<div class="col">
						<a href="<?php echo BASEURL; ?>">
							<img src="<?php echo PUBLICURL . 'uploads/upload_cad_institucional/' . $appInstitucionalDados->imagem; ?>" alt="<?php echo $appInstitucionalDados->titulo; ?>" alt="<?php echo $appInstitucionalDados->titulo; ?>" class="img-fluid">
						</a>
					</div>

					<div class="col d-flex justify-content-end align-items-center">
						<div class="btn-hamburguer header side-panel-toggle" data-extra-class="side-panel-right" data-location="header">
							<span>
								<div class="bg-white"></div>
								<div class="bg-white"></div>
								<div class="bg-white"></div>
							</span>
						</div>
					</div>
				</div>
			</div>
		</header>

		<!-- ---------------------------------------------------------------------------------------------------------- -->

		<div class="side-panel-wrapper" style="">
			<button class="hamburguer-btn side-panel-close side-panel-toggle" data-set-active="false">
				<span class="close">
					<span></span>
					<span></span>
				</span>
			</button>

			<aside class="sidebar d-flex justify-content-start align-content-start flex-column">
				<a class="m-0 mb-4 p-0 text-6 text-black lh-1" href="<?php echo BASEURL; ?>">
					Home
				</a>

				<a class="m-0 mb-4 p-0 text-6 text-black lh-1" href="<?php echo BASEURL . 'quem-somos'; ?>">
					Quem somos
				</a>

				<a class="m-0 mb-4 p-0 text-6 text-black lh-1" href="<?php echo BASEURL . 'galeria-de-fotos'; ?>">
					Galeria de Fotos
				</a>

				<?php foreach ($appGalerias as $key => $galeria) { ?>
					<a class="m-0 mb-4 p-0 ps-4 text-6 text-black lh-1" href="<?php echo BASEURL . 'galeria-de-fotos/' . $galeria->url_amigavel; ?>">
						- <?php echo $galeria->titulo; ?>
					</a>
				<?php } ?>

				<a class="m-0 mb-4 p-0 text-6 text-black lh-1" href="<?php echo BASEURL . 'blog'; ?>">
					Blog
				</a>

				<a class="m-0 mb-4 p-0 text-6 text-black lh-1" download href="<?php echo PUBLICURL . 'uploads/upload_cad_blocos/' . $appBlocos->bloco4_arquivo; ?>">
					<?php echo $appBlocos->bloco4_titulo; ?>
				</a>

				<a class="m-0 mb-4 p-0 text-6 text-black lh-1" href="<?php echo BASEURL . 'contato'; ?>">
					Contato
				</a>

				<a class="m-0 mb-4 p-0 text-6 text-black lh-1" href="<?php echo BASEURL . 'faca-um-orcamento'; ?>">
					Faça um orçamento
				</a>
			</aside>
		</div>