<?php
namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\I18n\Time;
use CodeIgniter\HTTP\UserAgent;
use CodeIgniter\Files\File;

use Psr\Log\LoggerInterface;

use Store\DataHelper;
use Constant\ConstantHelper;
use Upload\UploadHelper;

use App\Models\BaseModel;

abstract class BaseController extends Controller {

	/**
  * Instance of the main Request object.
  *
  * @var CLIRequest|IncomingRequest
  */

	protected $request;

	/**
  * An array of helpers to be loaded automatically upon
  * class instantiation. These helpers will be available
  * to all other controllers that extend BaseController.
  *
  * @var array
  */

	protected $helpers = ['form', 'date', 'html', 'number', 'text', 'filesystem'];

	/*
	* Constructor.
	*/

	protected $globalData = [];

	protected $baseModel 			= null;
	protected $dataHelper			= null;
	protected $constantHelper	= null;
	protected $uploadHelper		= null;

	public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger) {
		parent::initController($request, $response, $logger);

		$this->baseModel 			= new BaseModel;
		$this->dataHelper 		= new DataHelper;
		$this->constantHelper = new ConstantHelper;
		$this->uploadHelper 	= new UploadHelper;

		$class = str_replace(array('\\', '\\', '\\', '\\'), '/', service('router')->controllerName());
		$class = explode('/', $class);
		
		if(count($class) >= 4) {
			foreach ($class as $key => $cl) {
				$class[$key] = strtolower($cl);
			}

			$class = $class[4];
		}
		
		if($class != "login") {
			$this->globalData = $this->dataHelper->DH_loadGlobalData();
		}

		ini_set('memory_limit', '64M');
	}

	/**
	* Descrição aqui!
	* 
	* @version 1.0.0.0 - 2022-08-05
	* 
	* @param não definido ainda
	* 
	* @return não definido ainda
	*/ 
	
	protected function _cms($caminho, $dados = array()) {		
		$dados = array_merge($this->globalData, $dados);

		if(empty(service('session')->get('usuario'))) {
			echo view($caminho, $dados);
		}
		else {
			if(service("router")->methodName() != "imprimir") {
				echo view('Views\view_topo', $dados);
				echo view($caminho, $dados);
				echo view('Views\view_rodape', $dados);
			}
			else {
				echo view('Views\view_topo_assets', $dados);
				echo view($caminho, $dados);
				echo view('Views\view_rodape_assets', $dados);
			}
		}
	}

	/**
	* Descrição aqui!
	* 
	* @version 1.0.0.0 - 2022-08-05
	* 
	* @param não definido ainda
	* 
	* @return não definido ainda
	*/ 
	
	protected function _login($caminho, $dados = array()) {
		$dados['seo'] 						= $this->loginHelper->LG_getLoginSeo();
		$dados['MyAncora'] 				= $this->loginHelper->LG_getLoginAncoras();
		$dados['MyConfig'] 				= $this->loginHelper->LG_getLoginConfig();
		$dados['MyPlataforma']		= $this->loginHelper->LG_getPlataforma();
		$dados['MyCores'] 				= $this->loginHelper->LG_getCores();
		
		$dados['versionDate'] 		= date("Ymd") . "1";
		$dados['MyMod'] 					= "login";	

		echo view($caminho, $dados);
	}
}
