<?php
namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Store\DataHelper;

class CheckLogin implements FilterInterface {

  /*
  * Verifica se o usuario esta logado
  */

  public function before(RequestInterface $request, $arguments = null) {
  	$this->dataHelper = new DataHelper;
  	
  	if(!empty(service('session')->get('usuario'))) {
  		$classe 		= str_replace(array('\\', '\\', '\\', '\\'), '/', service('router')->controllerName());
  		$classe 		= strtolower(explode('/', $classe)[4]);

  		if($classe != "login") {
  			$db 				= \Config\Database::connect();

  			$table 			= "cms_modulos";
  			$builder  	= $db->table($table)->where('nome', $classe);
  			$query    	= $builder->get();

  			$result 		= $query->getRow();

  			$usuario 		= service('session')->get('usuario');
  			$permissoes = unserialize(base64_decode($usuario->permissoes));

  			$categorias = $permissoes['idMmoduloCategoria'];
  			$modulos 		= $permissoes['idMmodulo'];

  			if(!in_array($result->id, $modulos)) {
  				service('session')->set('msg', array('titulo' => 'Permissão negada', 'descricao' => 'Você não possui permissão para acessar este módulo.', 'tipo' => 'error'));

          $redirect = BASECMSURL . 'pagina-inicial';
  				return redirect()->to($redirect);
  			}
  		}
  	}
  }

  public function after(RequestInterface $request, ResponseInterface $response, $arguments = null) {
  }
}
