<?php
namespace App\Models;

use CodeIgniter\Model;
use CodeIgniter\I18n\Time;

use Store\DataHelper;
use Constant\ConstantHelper;

class BaseModel extends Model {

	protected $globalData = [];

	protected $dataHelper			= null;
	protected $constantHelper	= null;

	public function __construct() {
		$this->db = db_connect();

		$this->dataHelper 		= new DataHelper;
		$this->constantHelper = new ConstantHelper;

		$class = str_replace(array('\\', '\\', '\\', '\\'), '/', service('router')->controllerName());
		$class = explode('/', $class);
		
		if(count($class) >= 4) {
			foreach ($class as $key => $cl) {
				$class[$key] = strtolower($cl);
			}

			$class = $class[4];
		}
		
		if($class != "login") {
			$this->globalData = $this->dataHelper->DH_loadGlobalData();
		}
	}
}