<?php
namespace Modules\Cad_ancora\Controllers;

use App\Controllers\BaseController;
use Modules\Cad_ancora\Models\model_cad_ancora;

class Cad_ancora extends BaseController {
	public function __construct() {
		$this->model_cad_ancora = new Model_cad_ancora;
	}

	public function index() {
	}

	public function listagem() {
		$this->dataHelper->DH_actionRecord();
		$dados['cad_ancora'] = $this->model_cad_ancora->getCadastros();
		$this->_cms('Modules\Cad_ancora\Views\view_cad_ancora_listar', $dados);
	}

	public function cadastrar() {
		if($this->globalData['MyUser']->id_categoria == 1) {
			$this->dataHelper->DH_actionRecord();
			$this->_cms('Modules\Cad_ancora\Views\view_cad_ancora_cadastrar');
		}
		else {
			service('session')->set('msg', array('titulo' => 'Acesso negado!', 'descricao' => 'No momento você não possui permissão para acessar este módulo', 'tipo' => 'error'));
			return redirect()->to(BASECMSURL . service('request')->uri->getSegment(1));
		}
	}

	public function cadastrando() {
		$id = $this->model_cad_ancora->cadastrando();
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Novo cadastro', 'cad_ancora', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		if($id > 0) {
			if(isset($_FILES['imagem']) and $_FILES['imagem']['error'] == 0) {
				$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_ancora', '', 'upload_cad_ancora', 'item_' . $id, 'imagem', $id);
				$this->dataHelper->DH_actionRecordUpload('cad_ancora', $id, $fileReturn['msg']);
			}

			if(isset($_FILES['subimagem']) and $_FILES['subimagem']['error'] == 0) {
				$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_ancora', '', 'upload_cad_ancora', 'item_' . $id, 'subimagem', $id);
				$this->dataHelper->DH_actionRecordUpload('cad_ancora', $id, $fileReturn['msg']);
			}   

			service('session')->set('msg', array('titulo' => 'Sucesso', 'descricao' => 'Seu cadastro foi realizado.', 'tipo' => 'success'));
		}
		else {
			service('session')->set('msg', array('titulo' => 'Ops!', 'descricao' => 'Seu cadastro foi realizado, porém houve um problema ao salvar as imagens.', 'tipo' => 'error'));
		}

		return redirect()->to(BASECMSURL . service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id);
	}

	public function alterar($id) {
		$dados['id']         = $id;
		$dados['cad_ancora'] = $this->model_cad_ancora->alterar($id);
		$dados['logs']			 = $this->dataHelper->DH_getLogFile('cad_ancora', 'item_' . $id);

		if($dados['cad_ancora']->root == 1 AND $this->globalData['MyUser']->id_categoria == 1) {
			$this->dataHelper->DH_actionRecord($id);
			$this->_cms('Modules\Cad_ancora\Views\view_cad_ancora_cadastrar', $dados);
		}
		else if($dados['cad_ancora']->root == 1 AND $this->globalData['MyUser']->id_categoria != 1) {
			service('session')->set('msg', array('titulo' => 'Acesso negado!', 'descricao' => 'No momento você não possui permissão para acessar este módulo', 'tipo' => 'error'));
			return redirect()->to(BASECMSURL . service('request')->uri->getSegment(1));
		}
		else {
			$this->dataHelper->DH_actionRecord($id);
			$this->_cms('Modules\Cad_ancora\Views\view_cad_ancora_cadastrar', $dados);
		}
	}

	public function alterando($id) {
		$dados = $this->model_cad_ancora->alterar($id);

		if(isset($_FILES['imagem']) and $_FILES['imagem']['error'] == 0) {
			$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_ancora', $dados->imagem, 'upload_cad_ancora', 'item_' . $id, 'imagem', $id);
			$this->dataHelper->DH_actionRecordUpload('cad_ancora', $id, $fileReturn['msg']);
		}

		if(isset($_POST['rem_imagem']) AND $_POST['rem_imagem'] == 1) {
			$this->dataHelper->DH_deleteImage('cad_ancora', 'imagem', 'upload_cad_ancora', 'item_' . $id, $dados->imagem, $id);
		}

		if(isset($_FILES['subimagem']) and $_FILES['subimagem']['error'] == 0) {
			$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_ancora', '', 'upload_cad_ancora', 'item_' . $id, 'subimagem', $id);
			$this->dataHelper->DH_actionRecordUpload('cad_ancora', $id, $fileReturn['msg']);
		} 

		if(isset($_POST['rem_subimagem']) AND $_POST['rem_subimagem'] == 1) {
			$this->dataHelper->DH_deleteImage('cad_ancora', 'subimagem', 'upload_cad_ancora', 'item_' . $id, $dados->subimagem, $id);
		}

		unset($_POST['rem_imagem']);
		unset($_POST['rem_subimagem']);

		$this->model_cad_ancora->alterando($id);
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'cad_ancora', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
		return redirect()->to(BASECMSURL . service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id);
	}

	public function deletar($id) {
		$dados 	= $this->model_cad_ancora->alterar($id);
		
		if($dados->root == 1 AND $this->globalData['MyUser']->id_categoria == 1) {
			$this->dataHelper->DH_createLogFile($id, $dados, 'Exclusão de cadastro', 'cad_ancora', 'item_' . $id);
			$this->uploadHelper->UPH_deleteFolder('upload_cad_ancora', $id);
			$this->dataHelper->DH_actionRecord($id);

			$this->model_cad_ancora->deletar($id);

			service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
			return redirect()->to(BASECMSURL . service('request')->uri->getSegment(1));
		}
		else if($dados->root == 1 AND $this->globalData['MyUser']->id_categoria != 1) {
			service('session')->set('msg', array('titulo' => 'Acesso negado!', 'descricao' => 'No momento você não possui permissão para acessar este módulo', 'tipo' => 'error'));
			return redirect()->to(BASECMSURL . service('request')->uri->getSegment(1));
		}
		else {
			$this->dataHelper->DH_createLogFile($id, $dados, 'Exclusão de cadastro', 'cad_ancora', 'item_' . $id);
			$this->uploadHelper->UPH_deleteFolder('upload_cad_ancora', $id);
			$this->dataHelper->DH_actionRecord($id);

			$this->model_cad_ancora->deletar($id);

			service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
			return redirect()->to(BASECMSURL . service('request')->uri->getSegment(1));
		}
	}
}