<?php 
if(service('request')->uri->getSegment(2) == "novo-cadastro") { 
	echo form_open_multipart(BASECMSURL . $MyMod . "/cadastrando", array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
else { 
	echo form_open_multipart(BASECMSURL . $MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
?>

<div class="wrapper wrapper-content animated fadeInUp">
	<?php echo view('view_header'); ?>

	<?php if(isset($cad_ancora->data_cadastro) AND !empty($cad_ancora->data_cadastro)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_ancora->data_cadastro)); ?> </b>
						
						<?php if(isset($cad_ancora->data_alteracao) AND !empty($cad_ancora->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_ancora->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Formulário de cadastro
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="ativo" class="form-label">
								Status:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="ativo">
									<i class="fa-light fa-power-off"></i>
								</label>

								<select class="form-select" name="ativo" id="ativo">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cad_ancora->ativo) and $cad_ancora->ativo == 1) { echo 'selected'; } ?> value="1">Cadastro ativo</option>
									<option <?php if(isset($cad_ancora->ativo) and $cad_ancora->ativo == 0) { echo 'selected'; } ?> value="0">Cadastro inativo</option>
								</select>
							</div>
						</div>
						
						<div class="col-12">
							<label for="titulo" class="form-label">
								Título:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="titulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="titulo" aria-describedby="titulo" id="titulo" name="titulo" value="<?php if(isset($cad_ancora->titulo)) { echo $cad_ancora->titulo; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Imagem
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-6 border-end">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Imagem:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <?php if(isset($cad_ancora->imagem_largura)) { echo $cad_ancora->imagem_largura; }else { echo '?'; } ?> x <?php if(isset($cad_ancora->imagem_altura)) { echo $cad_ancora->imagem_altura; }else { echo '?'; } ?>
							</label>

							<?php if(isset($cad_ancora->imagem) and $cad_ancora->imagem) { ?>
								<a href="<?php echo PUBLICURL . 'uploads/upload_cad_ancora/item_' . $cad_ancora->id . '/' . $cad_ancora->imagem; ?>" data-gallery="gallery-logos" data-title="<?php if(isset($cad_ancora->titulo) and $cad_ancora->titulo) { echo $cad_ancora->titulo; } ?>">
									<center class="center-img">
										<img class="img-responsive" src="<?php echo PUBLICURL . 'uploads/upload_cad_ancora/item_' . $cad_ancora->id . '/' . $cad_ancora->imagem; ?>"/>
									</center>
								</a>										
							<?php } ?>
						</div>

						<div class="col-6">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Preview:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <?php if(isset($cad_ancora->imagem_largura)) { echo $cad_ancora->imagem_largura; }else { echo '?'; } ?> x <?php if(isset($cad_ancora->imagem_altura)) { echo $cad_ancora->imagem_altura; } else { echo '?'; } ?>
							</label>

							<center class="center-preview-img">
								<div class="image-preview" id="image-preview"></div>
							</center>

							<label title="Selecione a imagem." for="imagem" class="btn btn-primary w-100 mt-3">
								<input type="file" accept="image/*" name="imagem" id="imagem" data-holder="image-preview" class="d-none btn-imagem-preview">
								<i class="fa-light fa-image"></i> Selecionar imagem
							</label>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php if(!empty(service('session')->get('usuario')) AND service('session')->get('usuario')->id_categoria == 1) { ?> 
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title border-danger">
						<h5>
							Formulário de cadastro
						</h5>
					</div>

					<div class="ibox-content border-danger">
						<div class="row">
							<div class="col-12">
								<label for="atalho" class="form-label">
									Âncora:
								</label>

								<div class="input-group mb-3">
									<span class="input-group-text" id="atalho">
										<i class="fa-light fa-anchor"></i>
									</span>

									<input type="text" class="form-control" aria-label="atalho" aria-describedby="atalho" id="atalho" name="atalho" value="<?php if(isset($cad_ancora->atalho)) { echo $cad_ancora->atalho; } ?>">
								</div>
							</div>

							<div class="col-12">
								<label for="subtitulo" class="form-label">
									Subtítulo:
								</label>

								<div class="input-group mb-3">
									<span class="input-group-text" id="subtitulo">
										<i class="fa-light fa-align-left"></i>
									</span>

									<input type="text" class="form-control" aria-label="subtitulo" aria-describedby="subtitulo" id="subtitulo" name="subtitulo" value="<?php if(isset($cad_ancora->subtitulo)) { echo $cad_ancora->subtitulo; } ?>">
								</div>
							</div>

							<div class="col-12">
								<label for="cor" class="form-label">
									Cor:
								</label>

								<div class="input-group mb-0">
									<span class="input-group-text" id="cor">
										<i class="fa-light fa-palette"></i>
									</span>

									<input type="text" class="form-control" aria-label="cor" aria-describedby="cor" id="cor" name="cor" value="<?php if(isset($cad_ancora->cor)) { echo $cad_ancora->cor; } ?>">
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<?php if(!empty(service('session')->get('usuario')) AND service('session')->get('usuario')->id_categoria == 1) { ?> 
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title border-danger">
						<h5>
							Texto Descritivo
						</h5>
					</div>

					<div class="ibox-content border-danger">
						<div class="row">
							<div class="col-12">
								<label for="descricao" class="form-label">
									Descrição:
								</label>

								<div class="input-group mb-0">
									<span class="input-group-text" id="descricao">
										<i class="fa-light fa-align-left"></i>
									</span>

									<textarea class="form-control tinymce" cols="80" rows="10" id="descricao" name="descricao"><?php if(isset($cad_ancora->descricao)) { echo $cad_ancora->descricao; } ?></textarea>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<?php echo view('Views\view_logs'); ?>
</div>

<?php echo view('view_footer'); ?>
<?php echo form_close(); ?>