<?php
namespace Modules\Cad_banner\Controllers;

use App\Controllers\BaseController;
use Modules\Cad_banner\Models\model_cad_banner;

class Cad_banner extends BaseController {
	public function __construct() {
		$this->model_cad_banner = new Model_cad_banner;
	}

	public function index() {
	}
	
	public function listagem() {
		$dados['cad_banner'] = $this->model_cad_banner->getCadastros();

		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_banner\Views\view_cad_banner_listar', $dados);
	}

	public function cadastrar() {
		$dados['cad_categorias'] = $this->model_cad_banner->getCategorias();

		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_banner\Views\view_cad_banner_cadastrar', $dados);
	}

	public function cadastrando() {

    /*
    * Ordenação
    */

    if(isset($_POST['ordem']) AND !empty($_POST['ordem'])) {
    	$_POST['ordem'] = sprintf("%02d", $_POST['ordem']);
    }
    else {
    	$_POST['ordem'] = '00';
    }

    $id = $this->model_cad_banner->cadastrando();
    $this->dataHelper->DH_createLogFile($id, $_POST, 'Novo cadastro', 'cad_banner', 'item_' . $id);
    $this->dataHelper->DH_actionRecord($id);

    if($id > 0) {
    	if(isset($_FILES['imagem']) and $_FILES['imagem']['error'] == 0) {
    		$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_banner', '', 'upload_cad_banner', 'item_' . $id, 'imagem', $id);
    		$this->dataHelper->DH_actionRecordUpload('cad_banner', $id, $fileReturn['msg']);
    	}

    	if(isset($_FILES['imagem_mobile']) and $_FILES['imagem_mobile']['error'] == 0) {
    		$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_banner', '', 'upload_cad_banner', 'item_' . $id, 'imagem_mobile', $id);
    		$this->dataHelper->DH_actionRecordUpload('cad_banner', $id, $fileReturn['msg']);
    	}   

    	service('session')->set('msg', array('titulo' => 'Sucesso', 'descricao' => 'Seu cadastro foi realizado.', 'tipo' => 'success'));
    }
    else {
    	service('session')->set('msg', array('titulo' => 'Ops!', 'descricao' => 'Seu cadastro foi realizado, porém houve um problema ao salvar as imagens.', 'tipo' => 'error'));
    }

    return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
  }

  public function alterar($id) {
  	$dados['id']             = $id;
  	$dados['cad_banner']     = $this->model_cad_banner->alterar($id);
  	$dados['cad_categorias'] = $this->model_cad_banner->getCategorias();
  	$dados['logs']					 = $this->dataHelper->DH_getLogFile('cad_banner', 'item_' . $id);

  	$this->dataHelper->DH_actionRecord($id);
  	$this->_cms('Modules\Cad_banner\Views\view_cad_banner_cadastrar', $dados);
  }

  public function alterando($id) {

    /*
    * Ordenação
    */

    if(isset($_POST['ordem']) AND !empty($_POST['ordem'])) {
    	$_POST['ordem'] = sprintf("%02d", $_POST['ordem']);
    }
    else {
    	$_POST['ordem'] = '00';
    }

    $dados = $this->model_cad_banner->alterar($id);

    if(isset($_FILES['imagem']) and $_FILES['imagem']['error'] == 0) {
    	$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_banner', $dados->imagem, 'upload_cad_banner', 'item_' . $id, 'imagem', $id);
    	$this->dataHelper->DH_actionRecordUpload('cad_banner', $id, $fileReturn['msg']);
    }

    if(isset($_FILES['imagem_mobile']) and $_FILES['imagem_mobile']['error'] == 0) {
    	$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_banner', $dados->imagem_mobile, 'upload_cad_banner', 'item_' . $id, 'imagem_mobile', $id);
    	$this->dataHelper->DH_actionRecordUpload('cad_banner', $id, $fileReturn['msg']);
    }

    if(!empty($_POST['rem_imagem'])) {
    	$this->uploadHelper->UPH_deleteImage('cad_banner', 'imagem', 'upload_cad_banner', 'item_' . $id, $dados->imagem, $id);
    }

    if(!empty($_POST['rem_imagem_mobile'])) {
    	$this->uploadHelper->UPH_deleteImage('cad_banner', 'imagem_mobile', 'upload_cad_banner', 'item_' . $id, $dados->imagem_mobile, $id);
    }

    unset($_POST['rem_imagem']);
    unset($_POST['rem_imagem_mobile']);

    $this->model_cad_banner->alterando($id);
    $this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'cad_banner', 'item_' . $id);
    $this->dataHelper->DH_actionRecord($id);

    service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
    return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
  }

  public function deletar($id) {
  	$dados = $this->model_cad_banner->alterar($id);

  	$this->dataHelper->DH_createLogFile($id, $dados, 'Exclusão de cadastro', 'cad_banner', 'item_' . $id);
  	$this->uploadHelper->UPH_deleteFolder('upload_cad_banner', $id);
  	$this->dataHelper->DH_actionRecord($id);
  	
  	$this->model_cad_banner->deletar($id);

  	service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
  	return redirect()->to(site_url(service('request')->uri->getSegment(1)));
  }
}