<?php
namespace Modules\Cad_banner\Models;

use App\Models\BaseModel;

class Model_cad_banner extends BaseModel {
	public function getCadastros() {
		$table 			= "cad_banner";
		$builder  	= $this->db->table($table);
		
		$builder->select('cad_banner.*, cad_banner_categorias.titulo AS categoria');
		$builder->join('cad_banner_categorias', 'cad_banner_categorias.id = ' . $table . '.id_categoria', 'left');
		
		$query    	= $builder->get();

		return $query->getResult();
	}

	public function cadastrando() {
		$table 		= "cad_banner";
		$builder  = $this->db->table($table);
		$query    = $builder->insert($_POST);

		return $this->db->insertID();
	}

	public function alterar($id) {
		$table 		= "cad_banner";
		$builder  = $this->db->table($table);

		$builder->select('cad_banner.*, cad_banner_categorias.id AS id_categoria, cad_banner_categorias.largura AS largura, cad_banner_categorias.altura AS altura, cad_banner_categorias.largura_mobile AS largura_mobile, cad_banner_categorias.altura_mobile AS altura_mobile');
		$builder->join('cad_banner_categorias', 'cad_banner_categorias.id = ' . $table . '.id_categoria', 'left');
		$builder->where('cad_banner.id', $id);
		
		$query    = $builder->get();

		return $query->getRow();
	}

	public function alterando($id) {
		$table 		= "cad_banner";
		$builder  = $this->db->table($table);
		
		$builder->set('data_alteracao', date("Y-m-d H:i:s"));
		$builder->where('id', $id);
		$builder->update($_POST);

		return $id;
	}

	public function deletar($id) {
		$table 		= "cad_banner";
		$builder  = $this->db->table($table);
		
		$builder->where('id', $id);
		$builder->delete();
	}

	public function getCategorias() {
		$table 		= "cad_banner_categorias";
		$builder  = $this->db->table($table);
		$query    = $builder->get();

		return $query->getResult();
	}
}