<?php 
if(service('request')->uri->getSegment(2) == "novo-cadastro") { 
	echo form_open_multipart($MyMod . "/cadastrando", array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
else { 
	echo form_open_multipart($MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
?>

<div class="wrapper wrapper-content animated fadeInRight">
	<?php echo view('Views\view_header'); ?>

	<?php if(isset($cad_banner->data_cadastro) AND !empty($cad_banner->data_cadastro)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_banner->data_cadastro)); ?> </b>
						
						<?php if(isset($cad_banner->data_alteracao) AND !empty($cad_banner->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_banner->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Formulário de cadastro 
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="ativo" class="form-label">
								Status:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="ativo">
									<i class="fa-light fa-power-off"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="ativo" name="ativo">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cad_banner->ativo) and $cad_banner->ativo == 1) { echo 'selected'; } ?> value="1">Cadastro ativo</option>
									<option <?php if(isset($cad_banner->ativo) and $cad_banner->ativo == 0) { echo 'selected'; } ?> value="0">Cadastro inativo</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="id_categoria" class="form-label">
								Categorias:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="id_categoria">
									<i class="fa-light fa-gear"></i>
								</label>

								<select class="form-select select-banner-modulos" data-rule-required="true" data-msg-required="Campo obrigatório." id="id_categoria" name="id_categoria">
									<option value="" disabled selected hidden></option>
									<?php foreach ($cad_categorias as $key => $valor) { ?>
										<option data-width="<?php echo $valor->largura; ?>" data-height="<?php echo $valor->altura; ?>" data-width-mobile="<?php echo $valor->largura_mobile; ?>" data-height-mobile="<?php echo $valor->altura_mobile; ?>" <?php if(isset($cad_banner->id_categoria) AND $cad_banner->id_categoria == $valor->id) { echo 'selected'; } ?> value="<?php echo $valor->id; ?>">
											<?php echo $valor->titulo; ?>
										</option>
									<?php } ?>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="ordem" class="form-label">
								Ordem:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="ordem">
									<i class="fa-light fa-arrow-down-1-9"></i>
								</span>

								<input type="text" class="form-control" aria-label="ordem" aria-describedby="ordem" data-rule-required="true" data-msg-required="Campo obrigatório." id="ordem" name="ordem" value="<?php if(isset($cad_banner->ordem)) { echo $cad_banner->ordem; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="titulo" class="form-label">
								Título:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="titulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="titulo" aria-describedby="titulo" data-rule-required="true" data-msg-required="Campo obrigatório." id="titulo" name="titulo" value="<?php if(isset($cad_banner->titulo)) { echo $cad_banner->titulo; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Link
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="tipo" class="form-label">
								Tipo:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="tipo">
									<i class="fa-light fa-link"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="tipo" name="tipo">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cad_banner->tipo) AND $cad_banner->tipo == '0') { echo 'selected'; } ?> value="0">Sem link</option>
									<option <?php if(isset($cad_banner->tipo) AND $cad_banner->tipo == '1') { echo 'selected'; } ?> value="1">Com link</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="target" class="form-label">
								Ação do link:
							</label>
							
							<div class="input-group mb-3">
								<label class="input-group-text" for="target">
									<i class="fa-light fa-bullseye-pointer"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="target" name="target">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cad_banner->target) AND $cad_banner->target == '0') { echo 'selected'; } ?> value="0">Sem link</option>
									<option <?php if(isset($cad_banner->target) AND $cad_banner->target == '_blank') { echo 'selected'; } ?> value="_blank">Abrir em outra aba</option>
									<option <?php if(isset($cad_banner->target) AND $cad_banner->target == '_self') { echo 'selected'; } ?> value="_self">Abrir na mesma aba</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="link" class="form-label">
								Link:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="link">
									<i class="fa-light fa-link"></i>
								</span>

								<input type="text" class="form-control" aria-label="link" aria-describedby="link" id="link" name="link" value="<?php if(isset($cad_banner->link)) { echo $cad_banner->link; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Imagens
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-6 border-end">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Imagem para desktop ( computador ):
							</label>

							<br>

							<?php if(isset($id) AND !empty($id)) { ?>
								<label class="mb-3">
									<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-desktop"> Largura <b><?php echo $cad_banner->largura; ?></b> e altura <b><?php echo $cad_banner->altura; ?></b></span>
								</label>
							<?php } else { ?> 
								<label class="mb-3">
									<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-desktop"> Selecione a categoria. </span>
								</label>
							<?php } ?>

							<?php if(isset($cad_banner->imagem) and $cad_banner->imagem) { ?>
								<a href="<?php echo PUBLICURL . 'uploads/upload_cad_banner/' . $cad_banner->imagem; ?>" data-gallery="gallery-logos" data-title="<?php if(isset($cad_banner->titulo) and $cad_banner->titulo) { echo $cad_banner->titulo; } ?>">
									<center class="center-img">
										<img class="img-responsive" src="<?php echo PUBLICURL . 'uploads/upload_cad_banner/item_' . $cad_banner->id . '/' . $cad_banner->imagem; ?>"/>
									</center>
								</a>		

								<div class="i-checks mt-4">
									<input type="checkbox" name="rem_imagem" id="check1" value="1"/>
									<label for="check1"><i></i>&nbsp;Deixar sem imagem</label>
								</div>								
							<?php } else { ?>
								<center class="center-preview-img-below">
								</center>
							<?php } ?>

							<label class="mt-4 mb-2">
								<i class="fa-light fa-image"></i> Preview:
							</label>

							<br/>

							<?php if(isset($id) AND !empty($id)) { ?>
								<label class="mb-3">
									<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-desktop"> Largura <b><?php echo $cad_banner->largura; ?></b> e altura <b><?php echo $cad_banner->altura; ?></b></span>
								</label>
							<?php } else { ?> 
								<label class="mb-3">
									<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-desktop"> Selecione a categoria. </span>
								</label>
							<?php } ?>

							<center class="center-preview-img-below">
								<div class="image-preview" id="image-preview"></div>
							</center>

							<label title="Selecione a imagem." for="imagem" class="btn btn-primary w-100">
								<input type="file" accept="image/*" name="imagem" id="imagem" data-holder="image-preview" class="btn-imagem-preview" <?php if(empty($cad_banner->imagem)) { echo ''; } ?>>
								<i class="fa-light fa-computer"></i> Selecionar imagem para desktop ( computador )
							</label>
						</div>

						<div class="col-6">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Imagem para mobile ( celular/tablets ):
							</label>

							<br>

							<?php if(isset($id) AND !empty($id)) { ?>
								<label class="mb-3">
									<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-mobile"> Largura <b><?php echo $cad_banner->largura_mobile; ?></b> e altura <b><?php echo $cad_banner->altura_mobile; ?></b></span>
								</label>
							<?php } else { ?> 
								<label class="mb-3">
									<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-mobile"> Selecione a categoria. </span>
								</label>
							<?php } ?>

							<?php if(isset($cad_banner->imagem_mobile) and $cad_banner->imagem_mobile) { ?>
								<a href="<?php echo PUBLICURL . 'uploads/upload_cad_banner/' . $cad_banner->imagem_mobile; ?>" data-gallery="gallery-logos" data-title="<?php if(isset($cad_banner->titulo) and $cad_banner->titulo) { echo $cad_banner->titulo; } ?>">
									<center class="center-img">
										<img src="<?php echo PUBLICURL . 'uploads/upload_cad_banner/item_' . $cad_banner->id . '/' . $cad_banner->imagem_mobile; ?>"/>
									</center>
								</a>					

								<div class="i-checks mt-4">
									<input type="checkbox" name="rem_imagem_mobile" id="check2" value="1"/>
									<label for="check2"><i></i>&nbsp;Deixar sem imagem</label>
								</div>						
							<?php } else { ?>
								<center class="center-preview-img-below">
								</center>
							<?php } ?>

							<label class="mt-4 mb-2">
								<i class="fa-light fa-image"></i> Preview:
							</label>

							<br/>

							<?php if(isset($id) AND !empty($id)) { ?>
								<label class="mb-3">
									<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-mobile"> Largura <b><?php echo $cad_banner->largura_mobile; ?></b> e altura <b><?php echo $cad_banner->altura_mobile; ?></b></span>
								</label>
							<?php } else { ?> 
								<label class="mb-3">
									<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-mobile"> Selecione a categoria. </span>
								</label>
							<?php } ?>
							<center class="center-preview-img-below">
								<div class="image-preview" id="subimage-preview"></div>
							</center>

							<label title="Selecione a imagem." for="imagem_mobile" class="btn btn-primary w-100">
								<input type="file" accept="image/*" name="imagem_mobile" id="imagem_mobile" data-holder="subimage-preview" class="btn-imagem-preview" <?php if(empty($cad_banner->imagem_mobile)) { echo ''; } ?>>
								<i class="fa-light fa-mobile-notch"></i> Selecionar imagem para mobile ( celular/tablets )
							</label>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php echo view('Views\view_logs'); ?>
</div>

<?php echo view('Views\view_footer'); ?>
<?php echo form_close(); ?>