<?php
namespace Modules\Cad_banner_categorias\Controllers;

use App\Controllers\BaseController;
use Modules\Cad_banner_categorias\Models\model_cad_banner_categorias;
use Store\DataHelper;

class Cad_banner_categorias extends BaseController {
	public function __construct() {
		$this->dataHelper 						 		 = new DataHelper;
		$this->model_cad_banner_categorias = new Model_cad_banner_categorias;
	}

	public function index() {
	}
	
	public function listagem() {
		$dados['cad_banner_categorias'] = $this->model_cad_banner_categorias->getCadastros();

		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_banner_categorias\Views\view_cad_banner_categorias_listar', $dados);
	}

	public function cadastrar() {
		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_banner_categorias\Views\view_cad_banner_categorias_cadastrar');
	}

	public function cadastrando() {
		$id = $this->model_cad_banner_categorias->cadastrando();
		$this->dataHelper->DH_actionRecord($id);
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Novo cadastro', 'cad_banner_categorias', 'item_' . $id);
		service('session')->set('msg', array('titulo' => 'Sucesso', 'descricao' => 'Seu cadastro foi realizado.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function alterar($id) {
		$dados['id']                    = $id;
		$dados['cad_banner_categorias'] = $this->model_cad_banner_categorias->alterar($id);
		$dados['logs']									= $this->dataHelper->DH_getLogFile('cad_banner_categorias', 'item_' . $id);

		$this->dataHelper->DH_actionRecord($id);
		$this->_cms('Modules\Cad_banner_categorias\Views\view_cad_banner_categorias_cadastrar', $dados);
	}

	public function alterando($id) {
		$this->model_cad_banner_categorias->alterando($id);
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'cad_banner_categorias', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);
		service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function deletar($id) {
		$dados = $this->model_cad_banner_categorias->alterar($id);

		$this->dataHelper->DH_createLogFile($id, $dados, 'Exclusão de cadastro', 'cad_banner_categorias', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);
		
		$this->model_cad_banner_categorias->deletar($id);

		service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1)));
	}
}