<?php 
if(service('request')->uri->getSegment(2) == "novo-cadastro") { 
	echo form_open_multipart($MyMod . "/cadastrando", array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
else { 
	echo form_open_multipart($MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
?>

<div class="wrapper wrapper-content animated fadeInRight">
	<?php echo view('Views\view_header'); ?>

	<?php if(isset($cad_banner_categorias->data_cadastro) AND !empty($cad_banner_categorias->data_cadastro)) { ?>
		<div class="row">
			<div class="col-lg-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_banner_categorias->data_cadastro)); ?> </b>
						
						<?php if(isset($cad_banner_categorias->data_alteracao) AND !empty($cad_banner_categorias->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_banner_categorias->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="row">
		<div class="col-lg-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Formulário de cadastro
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="ativo" class="form-label">
								Status:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="ativo">
									<i class="fa-light fa-power-off"></i>
								</label>

								<select class="form-select" name="ativo" id="ativo">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cad_banner_categorias->ativo) and $cad_banner_categorias->ativo == 1) { echo 'selected'; } ?> value="1">Cadastro ativo</option>
									<option <?php if(isset($cad_banner_categorias->ativo) and $cad_banner_categorias->ativo == 0) { echo 'selected'; } ?> value="0">Cadastro inativo</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="titulo" class="form-label">
								Título:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="titulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="titulo" aria-describedby="titulo" required data-msg-required="Campo obrigatório" id="titulo" name="titulo" value="<?php if(isset($cad_banner_categorias->titulo)) { echo $cad_banner_categorias->titulo; } ?>">
							</div>
						</div>

						<div class="col-6">
							<label for="largura" class="form-label">
								Largura ( desktop ):
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="largura">
									<i class="fa-light fa-arrows-left-right"></i>
								</span>

								<input type="text" class="form-control" aria-label="largura" aria-describedby="largura" required data-msg-required="Campo obrigatório" id="largura" name="largura" value="<?php if(isset($cad_banner_categorias->largura)) { echo $cad_banner_categorias->largura; } ?>">
							</div>
						</div>

						<div class="col-6">
							<label for="altura" class="form-label">
								Altura ( desktop ):
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="altura">
									<i class="fa-light fa-arrows-up-down"></i>
								</span>

								<input type="text" class="form-control" aria-label="altura" aria-describedby="altura" required data-msg-required="Campo obrigatório" id="altura" name="altura" value="<?php if(isset($cad_banner_categorias->altura)) { echo $cad_banner_categorias->altura; } ?>">
							</div>
						</div>

						<div class="col-6">
							<label for="largura_mobile" class="form-label">
								Largura ( mobile ):
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="largura_mobile">
									<i class="fa-light fa-arrows-left-right"></i>
								</span>

								<input type="text" class="form-control" aria-label="largura_mobile" aria-describedby="largura_mobile" required data-msg-required="Campo obrigatório" id="largura_mobile" name="largura_mobile" value="<?php if(isset($cad_banner_categorias->largura_mobile)) { echo $cad_banner_categorias->largura_mobile; } ?>">
							</div>
						</div>

						<div class="col-6">
							<label for="altura_mobile" class="form-label">
								Altura ( mobile ):
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="altura_mobile">
									<i class="fa-light fa-arrows-up-down"></i>
								</span>

								<input type="text" class="form-control" aria-label="altura_mobile" aria-describedby="altura_mobile" required data-msg-required="Campo obrigatório" id="altura_mobile" name="altura_mobile" value="<?php if(isset($cad_banner_categorias->altura_mobile)) { echo $cad_banner_categorias->altura_mobile; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php if(service('session')->get('usuario')->id_categoria == 1) { ?> 
		<div class="row">
			<div class="col-lg-12">
				<div class="ibox float-e-margins border-danger">
					<div class="ibox-title">
						<h5>
							Formulário de cadastro
						</h5>
					</div>

					<div class="ibox-content">
						<div class="row">
							<div class="col-12">
								<label for="modulo" class="form-label">
									Módulo:
								</label>

								<div class="input-group mb-0">
									<span class="input-group-text" id="modulo">
										<i class="fa-light fa-cubes"></i>
									</span>

									<input type="text" class="form-control" aria-label="modulo" aria-describedby="modulo" required data-msg-required="Campo obrigatório" id="modulo" name="modulo" value="<?php if(isset($cad_banner_categorias->modulo)) { echo $cad_banner_categorias->modulo; } ?>">
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<?php echo view('Views\view_logs'); ?>
</div>

<?php echo view('Views\view_footer'); ?>
<?php echo form_close(); ?>