<?php
$routes->group(
	'cadastro-do-blog', 
	[
		'namespace' => 'Modules\Cad_blog\Controllers', 
		'filter'    => 'CheckAccessPermission'
	], 
	function ($routes) {
		$routes->get('/', 'Cad_blog::listagem');

		$routes->match(['get', 'post'], 'novo-cadastro', 'Cad_blog::cadastrar');
		$routes->post('cadastrando', 'Cad_blog::cadastrando');

		$routes->match(['get', 'post'], 'alterando-cadastro/(:any)', 'Cad_blog::alterar/$1');
		$routes->post('atualizando-cadastro/(:any)', 'Cad_blog::alterando/$1');

		$routes->get('deletando-cadastro/(:any)', 'Cad_blog::deletar/$1');
	}
);