<?php
namespace Modules\Cad_blog\Controllers;

use App\Controllers\BaseController;
use Modules\Cad_blog\Models\model_cad_blog;

class Cad_blog extends BaseController {
	public function __construct() {
		$this->model_cad_blog = new Model_cad_blog;
	}

	public function index() {
	}
	
	public function listagem() {
		$dados['cad_blog'] = $this->model_cad_blog->getCadastros();
		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_blog\Views\view_cad_blog_listar', $dados);
	}

	public function cadastrar() {
		$this->dataHelper->DH_actionRecord();
		$dados['categorias'] = $this->model_cad_blog->getCategorias();
		$this->_cms('Modules\Cad_blog\Views\view_cad_blog_cadastrar', $dados);
	}

	public function cadastrando() {
		$url                    = strtolower($this->dataHelper->DH_cleanString($_POST['titulo']));
		$urlAmigavel            = $this->dataHelper->DH_checkDuplicate('cad_blog', 'url_amigavel', $url, '');
		$_POST['url_amigavel']  = $urlAmigavel;

		if(!empty($_POST['titulo_extra'])) {
			$titulo_extra 		= $_POST['titulo_extra'];
			$descricao_extra 	= $_POST['descricao_extra'];

			unset($_POST['titulo_extra']);
			unset($_POST['descricao_extra']);
		}

		if(service('request')->getPost('video_code')) {
			$_POST['video_code'] = $this->dataHelper->DH_extractYouTubeID(service('request')->getPost('video_code'));
		}

		$id = $this->model_cad_blog->cadastrando();

	  /*
	  * Conteudo extra
	  */

	  if(isset($titulo_extra) AND !empty($titulo_extra)) {
	  	$arraySalva = [];

	  	foreach($titulo_extra as $key => $valor) {
	  		$arraySalva[$key]['titulo'] 	 = $titulo_extra[$key];
	  		$arraySalva[$key]['descricao'] = $descricao_extra[$key];

	  		if(isset($_FILES['imagem_extra']['name'][$key]) and $_FILES['imagem_extra']['error'][$key] == 0) {
	  			$imagem = $this->uploadHelper->UPH_uploadImage('cad_blog', '', 'upload_cad_blog', 'item_'.$id, 'imagem_extra', '', $key, false);

	  			if(!empty($imagem['img'])) {
	  				$arraySalva[$key]['imagem'] = $imagem['img'];
	  			}
	  			else {
	  				$arraySalva[$key]['imagem'] = '';
	  			}
	  		}
	  	}

	  	$_POST['extra'] = base64_encode(serialize($arraySalva));
	  }

	  $this->model_cad_blog->alterando($id);

	  $this->dataHelper->DH_createLogFile($id, $_POST, 'Novo cadastro', 'cad_blog', 'item_' . $id);
	  $this->dataHelper->DH_actionRecord($id);

	  if($id > 0) {
	  	if(isset($_FILES['imagem']) and $_FILES['imagem']['error'] == 0) {
	  		$this->uploadHelper->UPH_uploadImage('cad_blog', '', 'upload_cad_blog', 'item_' . $id, 'imagem', $id);
	  	}

	  	if(isset($_FILES['subimagem']) and $_FILES['subimagem']['error'] == 0) {
	  		$this->uploadHelper->UPH_uploadImage('cad_blog', '', 'upload_cad_blog', 'item_' . $id, 'subimagem', $id);
	  	}

	  	if(isset($_FILES['seo_imagem']) and $_FILES['seo_imagem']['error'] == 0) {
	  		$this->uploadHelper->UPH_uploadImage('cad_blog', '', 'upload_cad_blog', 'item_' . $id, 'seo_imagem', $id);
	  	}

	  	service('session')->set('msg', array('titulo' => 'Sucesso', 'descricao' => 'Seu cadastro foi realizado.', 'tipo' => 'success'));
	  }
	  else {
	  	service('session')->set('msg', array('titulo' => 'Ops!', 'descricao' => 'Houve um erro ao salvar os dados.', 'tipo' => 'error'));
	  }

	  return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function alterar($id) {
		$dados['id']            = $id;
		$dados['cad_blog']      = $this->model_cad_blog->alterar($id);
		$dados['categorias'] 		= $this->model_cad_blog->getCategorias();
		$dados['logs']				  = $this->dataHelper->DH_getLogFile('cad_blog', 'item_' . $id);

		$this->dataHelper->DH_actionRecord($id);
		$this->_cms('Modules\Cad_blog\Views\view_cad_blog_cadastrar', $dados);
	}

	public function alterando($id) {
		$dados = $this->model_cad_blog->alterar($id);

		/*
	  * Conteudo extra
	  */

		if(!empty($_POST['titulo_extra'])) {
			$conteudoNovo		= [];
			$conteudoAtual	= @unserialize(base64_decode($dados->extra));

			foreach($_POST['titulo_extra'] as $key => $valor) {
				$conteudoNovo[$key]['titulo'] 		= $_POST['titulo_extra'][$key];
				$conteudoNovo[$key]['descricao'] 	= $_POST['descricao_extra'][$key];

				if(!empty($_POST['rem_imagem_extra'][$key])) {
					$this->dataHelper->DH_deleteImage('cad_blog', 'imagem_extra', 'upload_cad_blog', 'item_' . $id, $conteudoAtual[$key]['imagem'], $id, false);
					$conteudoNovo[$key]['imagem'] = '0';
				}
				else {
					if(isset($_FILES['imagem_extra']['name'][$key]) and $_FILES['imagem_extra']['error'][$key] == 0) {
						$imagem = $this->uploadHelper->UPH_uploadImage('cad_blog', '', 'upload_cad_blog', 'item_'.$id, 'imagem_extra', '', $key, false);

						if(!empty($imagem['img'])) {
							$conteudoNovo[$key]['imagem'] = $imagem['img'];
						}
						else {
							$conteudoNovo[$key]['imagem'] = '0';
						}
					}
					else {
						if(isset($_POST['imagem_salva_extra'][$key]) AND !empty($_POST['imagem_salva_extra'][$key])) {
							$conteudoNovo[$key]['imagem'] = $_POST['imagem_salva_extra'][$key];
						}
					}
				}
			}

			/*
			* Remove a imagem do conteúdo extra excluido.
			*/

			if(isset($conteudoAtual) AND !empty($conteudoAtual)) {
				foreach ($conteudoAtual as $key => $atual) {
					if(!array_key_exists($key, $conteudoNovo)) {
						$this->dataHelper->DH_deleteImage('cad_blog', 'imagem_extra', 'upload_cad_blog', 'item_' . $id, $conteudoAtual[$key]['imagem'], $id, false);
					}
				}
			}

			unset($_POST['titulo_extra']);
			unset($_POST['descricao_extra']);
			unset($_POST['imagem_salva_extra']);
			unset($_POST['rem_imagem_extra']);

			$_POST['extra'] = base64_encode(serialize($conteudoNovo));
		}
		else {
			$extras = @unserialize(base64_decode($dados->extra));

			if(isset($extras) AND !empty($extras)) {
				foreach ($extras as $key => $extra) {
					$this->dataHelper->DH_deleteImage('cad_blog', 'imagem_extra', 'upload_cad_blog', 'item_' . $id, $extra['imagem'], $id, false);
				}
			}

			$_POST['extra'] = "";
		}

		if(isset($_FILES['imagem']) and $_FILES['imagem']['error'] == 0) {
			$this->uploadHelper->UPH_uploadImage('cad_blog', $dados->imagem, 'upload_cad_blog', 'item_'.$dados->id, 'imagem', $dados->id);
		}

		if(isset($_FILES['subimagem']) and $_FILES['subimagem']['error'] == 0) {
			$this->uploadHelper->UPH_uploadImage('cad_blog', $dados->subimagem, 'upload_cad_blog', 'item_'.$dados->id, 'subimagem', $dados->id);
		}

		if(isset($_FILES['seo_imagem']) and $_FILES['seo_imagem']['error'] == 0) {
			$this->uploadHelper->UPH_uploadImage('cad_blog', $dados->seo_imagem, 'upload_cad_blog', 'item_'.$dados->id, 'seo_imagem', $dados->id);
		}

		if(!empty($_POST['rem_imagem'])) {
			$this->dataHelper->DH_deleteImage('cad_blog', 'imagem', 'upload_cad_blog', 'item_' . $id, $dados->imagem, $id);
		}

		if(!empty($_POST['rem_subimagem'])) {
			$this->dataHelper->DH_deleteImage('cad_blog', 'subimagem', 'upload_cad_blog', 'item_' . $id, $dados->subimagem, $id);
		}

		unset($_POST['rem_imagem']);
		unset($_POST['rem_subimagem']);

		$url                    = strtolower($this->dataHelper->DH_cleanString($_POST['titulo']));
		$urlAmigavel            = $this->dataHelper->DH_checkDuplicate('cad_blog', 'url_amigavel', $url, $id);
		$_POST['url_amigavel']  = $urlAmigavel;

		if(service('request')->getPost('video_code')) {
			$_POST['video_code'] = $this->dataHelper->DH_extractYouTubeID(service('request')->getPost('video_code'));
		}

		$this->model_cad_blog->alterando($id);
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'cad_blog', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function deletar($id) {
		$dados = $this->model_cad_blog->alterar($id);

		$this->dataHelper->DH_createLogFile($id, $dados, 'Exclusão de cadastro', 'cad_blog', 'item_' . $id);
		$this->uploadHelper->UPH_deleteFolder('upload_cad_blog', $id);
		$this->dataHelper->DH_actionRecord($id);
		
		$this->model_cad_blog->deletar($id);

		service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1)));
	}
}
