<?php 
if(service('request')->uri->getSegment(2) == "novo-cadastro") { 
	echo form_open_multipart($MyMod . "/cadastrando", array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
else { 
	echo form_open_multipart($MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); 
} 

/*
* Dimensòes
*/

$imagemLargura 			= "350px";
$imagemAltura 			= "300px";

$subimagemLargura 	= "1140px";
$subimagemAltura 		= "450px";
?>

<div class="wrapper wrapper-content animated fadeInRight">
	<?php echo view('Views\view_header'); ?>

	<?php if(isset($cad_blog->data_cadastro) AND !empty($cad_blog->data_cadastro)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_blog->data_cadastro)); ?> </b>
						
						<?php if(isset($cad_blog->data_alteracao) AND !empty($cad_blog->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_blog->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Formulário de cadastro
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="ativo" class="form-label">
								Status:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="ativo">
									<i class="fa-light fa-power-off"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="ativo" name="ativo">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cad_blog->ativo) and $cad_blog->ativo == 1) { echo 'selected'; } ?> value="1">Cadastro ativo</option>
									<option <?php if(isset($cad_blog->ativo) and $cad_blog->ativo == 0) { echo 'selected'; } ?> value="0">Cadastro inativo</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="destaque" class="form-label">
								Destaque:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="destaque">
									<i class="fa-light fa-star"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="destaque" name="destaque">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cad_blog->destaque) and $cad_blog->destaque == 1) { echo 'selected'; } ?> value="1">Sim</option>
									<option <?php if(isset($cad_blog->destaque) and $cad_blog->destaque == 0) { echo 'selected'; } ?> value="0">Não</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="id_categoria" class="form-label">
								Categoria:
							</label>

							<div class="input-group mb-0">
								<label class="input-group-text" for="id_categoria">
									<i class="fa-light fa-gear"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="id_categoria" name="id_categoria">
									<option value="" disabled selected hidden></option>
									<?php foreach($categorias as $key => $categoria) { ?>
										<option <?php if(isset($cad_blog->id_categoria) and $cad_blog->id_categoria == $categoria->id) { echo 'selected'; } ?> value="<?php echo $categoria->id; ?>">
											<?php echo $categoria->titulo; ?>
										</option>
									<?php } ?>
								</select>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="titulo" class="form-label">
								Título:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="titulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="titulo" aria-describedby="titulo" data-rule-required="true" data-msg-required="Campo obrigatório." id="titulo" name="titulo" value="<?php if(isset($cad_blog->titulo)) { echo $cad_blog->titulo; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="subtitulo" class="form-label">
								Subtítulo:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="subtitulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="subtitulo" aria-describedby="subtitulo" data-rule-required="true" data-msg-required="Campo obrigatório." id="subtitulo" name="subtitulo" value="<?php if(isset($cad_blog->subtitulo)) { echo $cad_blog->subtitulo; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="resumo" class="form-label">
								Resumo:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="resumo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="resumo" aria-describedby="resumo" data-rule-required="true" data-msg-required="Campo obrigatório." id="resumo" name="resumo" value="<?php if(isset($cad_blog->resumo)) { echo $cad_blog->resumo; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="data" class="form-label">
								Data:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="data">
									<i class="fa-thin fa-calendar"></i>
								</span>

								<input type="text" class="form-control mask-calendar-default" aria-label="data" aria-describedby="data" data-rule-required="true" data-msg-required="Campo obrigatório." id="data" name="data" value="<?php if(isset($cad_blog->data)) { echo $cad_blog->data; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="autor" class="form-label">
								Publicado por:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="autor">
									<i class="fa-light fa-user-pen"></i>
								</span>

								<input type="text" class="form-control" aria-label="autor" aria-describedby="autor" data-rule-required="true" data-msg-required="Campo obrigatório." id="autor" name="autor" value="<?php if(isset($cad_blog->autor)) { echo $cad_blog->autor; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="descricao" class="form-label">
								Descrição:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="descricao">
									<i class="fa-light fa-align-left"></i>
								</span>

								<textarea class="form-control tinymce" cols="80" rows="10" data-rule-required="true" data-msg-required="Campo obrigatório." id="descricao" name="descricao"><?php if(isset($cad_blog->descricao)) { echo $cad_blog->descricao; } ?></textarea>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="video_code" class="form-label">
								Vídeo:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="video_code">
									<i class="fa-brands fa-youtube"></i>
								</span>

								<input type="text" class="form-control" aria-label="video_code" aria-describedby="video_code" id="video_code" name="video_code" value="<?php if(isset($cad_blog->video_code)) { echo $cad_blog->video_code; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-content">
					<div class="row">
						<div class="col-12 col-lg-6 border-end">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Imagem para listagem:
							</label>

							<br>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-desktop"> Largura <b><?php echo $imagemLargura; ?></b> e altura <b><?php echo $imagemAltura; ?></b></span>
							</label>

							<br>

							<?php if(isset($cad_blog->imagem) and $cad_blog->imagem) { ?>
								<a href="<?php echo PUBLICURL . 'uploads/upload_cad_blog/item_' . $cad_blog->id . '/' . $cad_blog->imagem; ?>" data-gallery="gallery-logos" data-title="<?php if(isset($cad_blog->titulo) and $cad_blog->titulo) { echo $cad_blog->titulo; } ?>">
									<center class="center-img">
										<img class="img-responsive" src="<?php echo PUBLICURL . 'uploads/upload_cad_blog/item_' . $cad_blog->id . '/' . $cad_blog->imagem; ?>"/>
									</center>
								</a>										
							<?php } ?>

							<label class="mt-4 mb-2">
								<i class="fa-light fa-image"></i> Preview:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-desktop"> Largura <b><?php echo $imagemLargura; ?></b> e altura <b><?php echo $imagemAltura; ?></b></span>
							</label>

							<center class="center-preview-img-below">
								<div class="image-preview" id="image-preview"></div>
							</center>

							<label title="Selecione a imagem." for="imagem" class="btn btn-primary w-100">
								<input type="file" accept="image/*" name="imagem" id="imagem" data-holder="image-preview" class="btn-imagem-preview" data-rule-required="true" data-msg-required="Campo obrigatório." <?php if(empty($cad_blog->imagem)) { echo ''; } ?>>
								<i class="fa-light fa-image"></i> Selecionar imagem para listagem
							</label>
						</div>

						<div class="col-12 col-lg-6 mt-4 mt-lg-0">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Imagem interna:
							</label>

							<br>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-mobile"> Largura <b><?php echo $subimagemLargura; ?></b> e altura <b><?php echo $subimagemAltura; ?></b></span>
							</label>

							<br>

							<?php if(isset($cad_blog->subimagem) and $cad_blog->subimagem) { ?>
								<a href="<?php echo PUBLICURL . 'uploads/upload_cad_blog/item_' . $cad_blog->id . '/' . $cad_blog->subimagem; ?>" data-gallery="gallery-logos" data-title="<?php if(isset($cad_blog->titulo) and $cad_blog->titulo) { echo $cad_blog->titulo; } ?>">
									<center class="center-img">
										<img src="<?php echo PUBLICURL . 'uploads/upload_cad_blog/item_' . $cad_blog->id . '/' . $cad_blog->subimagem; ?>"/>
									</center>
								</a>										
							<?php } ?>

							<label class="mt-4 mb-2">
								<i class="fa-light fa-image"></i> Preview:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-mobile"> Largura <b><?php echo $subimagemLargura; ?></b> e altura <b><?php echo $subimagemAltura; ?></b></span>
							</label>

							<center class="center-preview-img-below">
								<div class="image-preview" id="subimage-preview"></div>
							</center>

							<label title="Selecione a imagem." for="subimagem" class="btn btn-primary w-100">
								<input type="file" accept="image/*" name="subimagem" id="subimagem" data-holder="subimage-preview" class="btn-imagem-preview" data-rule-required="true" data-msg-required="Campo obrigatório." <?php if(empty($cad_blog->subimagem)) { echo ''; } ?>>
								<i class="fa-light fa-image"></i> Selecionar imagem interna
							</label>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Textos para o SEO ( Search Engine Optimization )
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="seo_titulo" class="form-label">
								Título:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="seo_titulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="seo_titulo" aria-describedby="seo_titulo" data-rule-required="true" data-msg-required="Campo obrigatório." id="seo_titulo" name="seo_titulo" value="<?php if(isset($cad_blog->seo_titulo)) { echo $cad_blog->seo_titulo; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="seo_descricao" class="form-label">
								Descrição:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="seo_descricao">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="seo_descricao" aria-describedby="seo_descricao" data-rule-required="true" data-msg-required="Campo obrigatório." id="seo_descricao" name="seo_descricao" value="<?php if(isset($cad_blog->seo_descricao)) { echo $cad_blog->seo_descricao; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="seo_autor" class="form-label">
								Autor:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="seo_autor">
									<i class="fa-light fa-user"></i>
								</span>

								<input type="text" class="form-control" aria-label="seo_autor" aria-describedby="seo_autor" data-rule-required="true" data-msg-required="Campo obrigatório." id="seo_autor" name="seo_autor" value="<?php if(isset($cad_blog->seo_autor)) { echo $cad_blog->seo_autor; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="seo_tags" class="form-label">
								Tags:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="seo_tags">
									<i class="fa-light fa-tags"></i>
								</span>

								<input type="text" class="form-control" aria-label="seo_tags" aria-describedby="seo_tags" data-rule-required="true" data-msg-required="Campo obrigatório." id="seo_tags" name="seo_tags" value="<?php if(isset($cad_blog->seo_tags)) { echo $cad_blog->seo_tags; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-content">
					<div class="row">
						<div class="col-6 border-end">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Imagem:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: Largura <b>500px</b> e altura <b>500px</b>
							</label>

							<?php if(isset($cad_blog->seo_imagem) and $cad_blog->seo_imagem) { ?>
								<a href="<?php echo PUBLICURL . 'uploads/upload_cad_blog/item_' . $cad_blog->id . '/' . $cad_blog->seo_imagem; ?>" data-gallery="gallery-logos" data-title="<?php if(isset($cad_blog->titulo) and $cad_blog->titulo) { echo $cad_blog->titulo; } ?>">
									<center class="center-img">
										<img class="img-responsive" src="<?php echo PUBLICURL . 'uploads/upload_cad_blog/item_' . $cad_blog->id . '/' . $cad_blog->seo_imagem; ?>"/>
									</center>
								</a>										
							<?php } ?>
						</div>

						<div class="col-6">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Preview:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: Largura <b>500px</b> e altura <b>500px</b>
							</label>

							<center class="center-preview-img">
								<div class="image-preview" id="image-seo-preview"></div>
							</center>

							<label title="Selecione a imagem." for="seo_imagem" class="btn btn-primary w-100 mt-3">
								<input type="file" accept="image/*" name="seo_imagem" id="seo_imagem" data-holder="image-seo-preview" class="d-none btn-imagem-preview" data-rule-required="true" data-msg-required="Campo obrigatório.">
								<i class="fa-light fa-image"></i> Selecionar imagem
							</label>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="div-extra-content">
		<?php $conteudoExtra = @unserialize(base64_decode($cad_blog->extra)); ?>

		<?php if($conteudoExtra AND !empty($conteudoExtra)) { ?>
			
			<?php foreach($conteudoExtra as $key => $conteudo) { ?>
				<div class="row row-extra-content row-extra-content-<?php echo $key; ?>">
					<div class="col-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<h3 class="m-0">
									<i class="fa-light fa-plus"></i> Conteúdo extra - #<?php echo $key; ?>
								</h3>
							</div>
						</div>
					</div>

					<div class="col-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title d-flex justify-content-between pr-3">
								<h5>
									Formulário de cadastro #<?php echo $key; ?>
								</h5>

								<button type="button" onclick="delExtraContent(<?php echo $key; ?>);" class="badge badge-danger border-0 rounded-0 btn-del-extra-content">
									<i class="fa-light fa-trash"></i> Excluir
								</button>
							</div>

							<div class="ibox-content">
								<div class="row">
									<div class="col-12">
										<label for="titulo_extra[<?php echo $key?>]" class="form-label">
											Título #<?php echo $key; ?>:
										</label>

										<div class="input-group mb-3">
											<span class="input-group-text" id="titulo_extra[<?php echo $key?>]">
												<i class="fa-light fa-align-left"></i>
											</span>

											<input type="text" class="form-control" aria-label="titulo_extra[<?php echo $key?>]" aria-describedby="titulo_extra[<?php echo $key?>]" data-rule-required="true" data-msg-required="Campo obrigatório." id="titulo_extra[<?php echo $key?>]" name="titulo_extra[<?php echo $key?>]" value="<?php if(isset($conteudo['titulo'])) { echo $conteudo['titulo']; } ?>">
										</div>
									</div>

									<div class="col-12">
										<label for="descricao_extra[<?php echo $key; ?>]" class="form-label">
											Descrição #<?php echo $key; ?>:
										</label>

										<div class="input-group mb-0">
											<span class="input-group-text" id="descricao_extra[<?php echo $key; ?>]">
												<i class="fa-light fa-align-left"></i>
											</span>

											<textarea class="form-control" cols="80" rows="10" data-rule-required="true" data-msg-required="Campo obrigatório." id="descricao_extra[<?php echo $key; ?>]" name="descricao_extra[<?php echo $key; ?>]"><?php if(isset($conteudo['descricao'])) { echo $conteudo['descricao']; } ?></textarea>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>

					<div class="col-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title d-flex justify-content-between pr-3">
								<h5>
									Imagens #<?php echo $key; ?>
								</h5>
							</div>

							<div class="ibox-content">
								<div class="row">
									<div class="col-6 border-end">
										<label class="mb-2">
											<i class="fa-light fa-image"></i> Imagem #<?php echo $key; ?>:
										</label>

										<br/>

										<label class="mb-3">
											<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: Largura <b>500px</b> e altura <b>500px</b>
										</label>

										<?php if(isset($conteudo['imagem']) and $conteudo['imagem']) { ?>
											<a href="<?php echo PUBLICURL . 'uploads/upload_cad_blog/item_' . $cad_blog->id . '/' . $conteudo['imagem']; ?>" data-gallery="gallery-logos" data-title="<?php if(isset($cad_blog->titulo) and $cad_blog->titulo) { echo $cad_blog->titulo; } ?>">
												<center class="center-img">
													<img class="img-responsive" src="<?php echo PUBLICURL . 'uploads/upload_cad_blog/item_' . $cad_blog->id . '/' . $conteudo['imagem']; ?>"/>
												</center>
											</a>										
										<?php } ?>
									</div>

									<div class="col-6">
										<label class="mb-2">
											<i class="fa-light fa-image"></i> Preview #<?php echo $key; ?>:
										</label>

										<br/>

										<label class="mb-3">
											<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: Largura <b>500px</b> e altura <b>500px</b>
										</label>

										<center class="center-preview-img">
											<div class="image-preview" id="imagem-<?php echo $key; ?>-preview"></div>
										</center>

										<label title="Selecione a imagem." for="imagem_extra[<?php echo $key; ?>]" class="btn btn-primary w-100 mt-3">
											<input type="file" accept="image/*" name="imagem_extra[<?php echo $key; ?>]" id="imagem_extra[<?php echo $key; ?>]" data-holder="imagem-<?php echo $key; ?>-preview" class="d-none btn-imagem-preview">
											<input type="hidden" name="imagem_salva_extra[<?php echo $key; ?>]" value="<?php if(!empty($conteudo['imagem'])) { echo $conteudo['imagem']; } ?>">
											<i class="fa-light fa-image"></i> Selecionar imagem
										</label>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			<?php } ?>

		<?php } ?>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title p-3">
					<button class="btn btn-success btn-extra m-0 w-100" type="button" data-mod="Cad_blog" data-view="view_cad_blog_extra">
						<i class="fa-light fa-layer-plus"></i>
						<span class="d-none d-lg-inline-block">
							Adicionar conteúdo extra
						</span>
					</button>
				</div>
			</div>
		</div>
	</div>

	<?php echo view('Views\view_logs'); ?>
</div>

<?php echo view('Views\view_footer'); ?>
<?php echo form_close(); ?>
