<?php
namespace Modules\Cad_blog_categorias\Controllers;

use App\Controllers\BaseController;
use Modules\Cad_blog_categorias\Models\model_cad_blog_categorias;

class Cad_blog_categorias extends BaseController {
	public function __construct() {
		$this->model_cad_blog_categorias = new Model_cad_blog_categorias;
	}

	public function index() {
	}
	
	public function listagem() {
		$dados['cad_blog_categorias'] = $this->model_cad_blog_categorias->getCadastros();
		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_blog_categorias\Views\view_cad_blog_categorias_listar', $dados);
	}

	public function cadastrar() {
		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_blog_categorias\Views\view_cad_blog_categorias_cadastrar');
	}

	public function cadastrando() {
		$url                    = strtolower($this->dataHelper->DH_cleanString($_POST['titulo']));
		$urlAmigavel            = $this->dataHelper->DH_checkDuplicate('cad_blog_categorias', 'url_amigavel', $url, '');
		$_POST['url_amigavel']  = $urlAmigavel;

		$id = $this->model_cad_blog_categorias->cadastrando();

		if($id > 0) {
			if(isset($_FILES['seo_imagem']) and $_FILES['seo_imagem']['error'] == 0) {
				$this->dataHelper->DH_uploadImage('cad_blog_categorias', '', 'upload_cad_blog_categorias', 'item_'.$id, 'seo_imagem', $id);
			}
		}

		$this->dataHelper->DH_createLogFile($id, $_POST, 'Novo cadastro', 'cad_blog_categorias', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso', 'descricao' => 'Seu cadastro foi realizado.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function alterar($id) {
		$dados['id']                  = $id;
		$dados['cad_blog_categorias'] = $this->model_cad_blog_categorias->alterar($id);
		$dados['logs']								= $this->dataHelper->DH_getLogFile('cad_blog_categorias', 'item_' . $id);

		$this->dataHelper->DH_actionRecord($id);
		$this->_cms('Modules\Cad_blog_categorias\Views\view_cad_blog_categorias_cadastrar', $dados);
	}

	public function alterando($id) {
		$dados = $this->model_cad_blog_categorias->alterar($id);
		
		$url                    = strtolower($this->dataHelper->DH_cleanString($_POST['titulo']));
		$urlAmigavel            = $this->dataHelper->DH_checkDuplicate('cad_blog_categorias', 'url_amigavel', $url, $id);
		$_POST['url_amigavel']  = $urlAmigavel;

		if(isset($_FILES['seo_imagem']) and $_FILES['seo_imagem']['error'] == 0) {
			$this->dataHelper->DH_uploadImage('cad_blog_categorias', $dados->seo_imagem, 'upload_cad_blog_categorias', 'item_'.$dados->id, 'seo_imagem', $dados->id);
		}

		$this->model_cad_blog_categorias->alterando($id);
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'cad_blog_categorias', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function deletar($id) {
		$dados = $this->model_cad_blog_categorias->alterar($id);
		
		$this->dataHelper->DH_createLogFile($id, $dados, 'Exclusão de cadastro', 'cad_blog_categorias', 'item_' . $id);
		$this->uploadHelper->UPH_deleteFolder('upload_blog_categorias', $id);
		$this->dataHelper->DH_actionRecord($id);

		$this->model_cad_blog_categorias->deletar($id);

		service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1)));
	}
}
