<?php 
if(service('request')->uri->getSegment(2) == "novo-cadastro") { 
	echo form_open_multipart($MyMod . "/cadastrando", array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
else { 
	echo form_open_multipart($MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
?>

<div class="wrapper wrapper-content animated fadeInRight">
	<?php echo view('Views\view_header'); ?>

	<?php if(isset($cad_blog_categorias->data_cadastro) AND !empty($cad_blog_categorias->data_cadastro)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_blog_categorias->data_cadastro)); ?> </b>
						
						<?php if(isset($cad_blog_categorias->data_alteracao) AND !empty($cad_blog_categorias->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_blog_categorias->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>Formulário de cadastro</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="ativo" class="form-label">
								Status:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="ativo">
									<i class="fa-light fa-power-off"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="ativo" name="ativo">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cad_blog_categorias->ativo) and $cad_blog_categorias->ativo == 1) { echo 'selected'; } ?> value="1">Cadastro ativo</option>
									<option <?php if(isset($cad_blog_categorias->ativo) and $cad_blog_categorias->ativo == 0) { echo 'selected'; } ?> value="0">Cadastro inativo</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="titulo" class="form-label">
								Título:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="titulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="titulo" aria-describedby="titulo" data-rule-required="true" data-msg-required="Campo obrigatório." id="titulo" name="titulo" value="<?php if(isset($cad_blog_categorias->titulo)) { echo $cad_blog_categorias->titulo; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Textos para o SEO ( Search Engine Optimization )
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="seo_titulo" class="form-label">
								Título:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="seo_titulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="seo_titulo" aria-describedby="seo_titulo" data-rule-required="true" data-msg-required="Campo obrigatório." id="seo_titulo" name="seo_titulo" value="<?php if(isset($cad_blog_categorias->seo_titulo)) { echo $cad_blog_categorias->seo_titulo; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="seo_descricao" class="form-label">
								Descrição:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="seo_descricao">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="seo_descricao" aria-describedby="seo_descricao" data-rule-required="true" data-msg-required="Campo obrigatório." id="seo_descricao" name="seo_descricao" value="<?php if(isset($cad_blog_categorias->seo_descricao)) { echo $cad_blog_categorias->seo_descricao; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="seo_autor" class="form-label">
								Autor:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="seo_autor">
									<i class="fa-light fa-user"></i>
								</span>

								<input type="text" class="form-control" aria-label="seo_autor" aria-describedby="seo_autor" data-rule-required="true" data-msg-required="Campo obrigatório." id="seo_autor" name="seo_autor" value="<?php if(isset($cad_blog_categorias->seo_autor)) { echo $cad_blog_categorias->seo_autor; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="seo_tags" class="form-label">
								Tags:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="seo_tags">
									<i class="fa-light fa-tags"></i>
								</span>

								<input type="text" class="form-control" aria-label="seo_tags" aria-describedby="seo_tags" data-rule-required="true" data-msg-required="Campo obrigatório." id="seo_tags" name="seo_tags" value="<?php if(isset($cad_blog_categorias->seo_tags)) { echo $cad_blog_categorias->seo_tags; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Imagem para o SEO ( Search Engine Optimization )
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-6 border-end">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Imagem:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: Largura <b>500px</b> e altura <b>500px</b>
							</label>

							<?php if(isset($cad_blog_categorias->seo_imagem) and $cad_blog_categorias->seo_imagem) { ?>
								<a href="<?php echo PUBLICURL . 'uploads/upload_cad_blog_categorias/item_' . $cad_blog_categorias->id . '/' . $cad_blog_categorias->seo_imagem; ?>" data-gallery="gallery-logos" data-title="<?php if(isset($cad_blog_categorias->titulo) and $cad_blog_categorias->titulo) { echo $cad_blog_categorias->titulo; } ?>">
									<center class="center-img">
										<img class="img-responsive" src="<?php echo PUBLICURL . 'uploads/upload_cad_blog_categorias/item_' . $cad_blog_categorias->id . '/' . $cad_blog_categorias->seo_imagem; ?>"/>
									</center>
								</a>										
							<?php } ?>
						</div>

						<div class="col-6">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Preview:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: Largura <b>500px</b> e altura <b>500px</b>
							</label>

							<center class="center-preview-img">
								<div class="image-preview" id="image-seo-preview"></div>
							</center>

							<label title="Selecione a imagem." for="seo_imagem" class="btn btn-primary w-100 mt-3">
								<input type="file" accept="image/*" name="seo_imagem" id="seo_imagem" data-holder="image-seo-preview" class="d-none btn-imagem-preview">
								<i class="fa-light fa-image"></i> Selecionar imagem
							</label>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php echo view('Views\view_logs'); ?>
</div>

<?php echo view('Views\view_footer'); ?>
<?php echo form_close(); ?>
