<?php
$routes->group(
	'cadastro-de-cidades', 
	[
		'namespace' => 'Modules\Cad_cidades\Controllers', 
		'filter'    => 'CheckAccessPermission'
	], 
	function ($routes) {
		$routes->get('/', 'Cad_cidades::listagem');

		$routes->match(['get', 'post'], 'novo-cadastro', 'Cad_cidades::cadastrar');
		$routes->post('cadastrando', 'Cad_cidades::cadastrando');

		$routes->match(['get', 'post'], 'alterando-cadastro/(:any)', 'Cad_cidades::alterar/$1');
		$routes->post('atualizando-cadastro/(:any)', 'Cad_cidades::alterando/$1');

		$routes->get('deletando-cadastro/(:any)', 'Cad_cidades::deletar/$1');
	}
);