<?php
namespace Modules\Cad_cidades\Controllers;

use App\Controllers\BaseController;
use Modules\Cad_cidades\Models\model_cad_cidades;

class Cad_cidades extends BaseController {
	public function __construct() {
		$this->model_cad_cidades = new Model_cad_cidades;
	}

	public function index() {
	}

	public function listagem() {
		$dados['cad_cidades'] = $this->model_cad_cidades->getCadastros();
		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_cidades\Views\view_cad_cidades_listar', $dados);
	}

	public function cadastrar() {
		$dados['cad_estados'] = $this->model_cad_cidades->getEstados();
		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_cidades\Views\view_cad_cidades_cadastrar', $dados);
	}

	public function cadastrando() {
		$id = $this->model_cad_cidades->cadastrando();

		if($id > 0) {
			service('session')->set('msg', array('titulo' => 'Sucesso', 'descricao' => 'Seu cadastro foi realizado.', 'tipo' => 'success'));
		}
		else {
			service('session')->set('msg', array('titulo' => 'Ops!', 'descricao' => 'Houve um erro ao salvar os dados.', 'tipo' => 'error'));
		}

		return redirect()->to(site_url('cad_cidades/alterar/'.$id));
	}

	public function alterar($id) {
		$dados['id']           = $id;
		$dados['cad_cidades'] = $this->model_cad_cidades->alterar($id);
		$dados['cad_estados'] = $this->model_cad_cidades->getEstados();
		$this->_cms('Modules\Cad_cidades\Views\view_cad_cidades_cadastrar', $dados);
	}

	public function alterando($id) {
		$id = $this->model_cad_cidades->alterando($id);
		service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
		return redirect()->to(site_url('cadastro-de-cidades/alterando-cadastro/'.$id));
	}

	public function deletar($id) {
		$this->model_cad_cidades->deletar($id);
		service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
		return redirect()->to(site_url('cadastro-de-cidades/alterando-cadastro'));
	}
}