<?php
namespace Modules\Cad_cidades\Models;

use App\Models\BaseModel;

class Model_cad_cidades extends BaseModel {
	public function getCadastros() {
		$table 			= "cad_cidades";
		$builder  	= $this->db->table($table);
		
		$builder->select($table . '.*, cad_estados.titulo AS estado, cad_estados.uf AS uf');
		$builder->join('cad_estados', 'cad_estados.id = ' . $table . '.id_estado', 'left');
		
		$query = $builder->get();
		return $query->getResult();
	}
	
	public function cadastrando() {
		$table 		= "cad_cidades";
		$builder  = $this->db->table($table);
		$query    = $builder->insert($_POST);

		return $this->db->insertID();
	}

	public function alterar($id) {
		$table 		= "cad_cidades";
		$builder  = $this->db->table($table)->where('id', $id);

		$query    = $builder->get();
		return $query->getRow();
	}

	public function alterando($id) {
		$table 		= "cad_cidades";
		$builder  = $this->db->table($table);

		$builder->set('data_alteracao', date("Y-m-d H:i:s"));
		$builder->where('id', $id);

		$builder->update($_POST);
		return $id;
	}

	public function deletar($id) {
		$table 		= "cad_cidades";
		$builder  = $this->db->table($table);
		$builder->where('id', $id);
		$builder->delete();
	}

	public function getEstados() {
		$table 		= 'cad_estados';
		$builder 	= $this->db->table($table);
		$query 		= $builder->get();

		return $query->getResult();
	}
}