<?php 
if(service('request')->uri->getSegment(2) == "novo-cadastro") { 
	echo form_open_multipart($MyMod . "/cadastrando", array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
else { 
	echo form_open_multipart($MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
?>

<div class="wrapper wrapper-content animated fadeInRight">
	<?php echo view('Views\view_header'); ?>

	<?php if(isset($cad_cidades->data_cadastro) AND !empty($cad_cidades->data_cadastro)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_cidades->data_cadastro)); ?> </b>
						
						<?php if(isset($cad_cidades->data_alteracao) AND !empty($cad_cidades->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_cidades->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>Formulário de cadastro</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="ativo" class="form-label">
								Status:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="ativo">
									<i class="fa-light fa-power-off"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="ativo" name="ativo">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cad_cidades->ativo) and $cad_cidades->ativo == 1) { echo 'selected'; } ?> value="1">Cadastro ativo</option>
									<option <?php if(isset($cad_cidades->ativo) and $cad_cidades->ativo == 0) { echo 'selected'; } ?> value="0">Cadastro inativo</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="id_estado" class="form-label">
								Estados:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="id_estado">
									<i class="fa-light fa-gear"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="id_estado" name="id_estado">
									<option value="" disabled selected hidden></option>
									<?php foreach ($cad_estados as $key => $estado) { ?>
										<option <?php if(isset($cad_cidades->id_estado) AND $cad_cidades->id_estado == $estado->id) { echo 'selected'; } ?> value="<?php echo $estado->id; ?>">
											<?php echo $estado->titulo; ?>
										</option>
									<?php } ?>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="titulo" class="form-label">
								Título:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="titulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="titulo" aria-describedby="titulo" data-rule-required="true" data-msg-required="Campo obrigatório." id="titulo" name="titulo" value="<?php if(isset($cad_cidades->titulo)) { echo $cad_cidades->titulo; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="latitude" class="form-label">
								Latitude:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="latitude">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="latitude" aria-describedby="latitude" data-rule-required="true" data-msg-required="Campo obrigatório." id="latitude" name="latitude" value="<?php if(isset($cad_cidades->latitude)) { echo $cad_cidades->latitude; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="longitude" class="form-label">
								Longitude:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="longitude">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="longitude" aria-describedby="longitude" data-rule-required="true" data-msg-required="Campo obrigatório." id="longitude" name="longitude" value="<?php if(isset($cad_cidades->longitude)) { echo $cad_cidades->longitude; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<?php echo view('Views\view_footer'); ?>
<?php echo form_close(); ?>