<?php
$routes->group(
	'cadastro-de-estados', 
	[
		'namespace' => 'Modules\Cad_estados\Controllers', 
		'filter'        => 'CheckAccessPermission'
	], 
	function ($routes) {
		$routes->get('/', 'Cad_estados::listagem');

		$routes->match(['get', 'post'], 'novo-cadastro', 'Cad_estados::cadastrar');
		$routes->post('cadastrando', 'Cad_estados::cadastrando');

		$routes->match(['get', 'post'], 'alterando-cadastro/(:any)', 'Cad_estados::alterar/$1');
		$routes->post('atualizando-cadastro/(:any)', 'Cad_estados::alterando/$1');

		$routes->get('deletando-cadastro/(:any)', 'Cad_estados::deletar/$1');
	}
);
