<?php
namespace Modules\Cad_estados\Controllers;

use App\Controllers\BaseController;
use Modules\Cad_estados\Models\model_cad_estados;

class Cad_estados extends BaseController {
	public function __construct() {
		$this->model_cad_estados = new Model_cad_estados;
	}

	public function index() {
	}
	
	public function listagem() {
		$dados['cad_estados'] = $this->model_cad_estados->getCadastros();
		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_estados\Views\view_cad_estados_listar', $dados);
	}

	public function cadastrar() {
		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_estados\Views\view_cad_estados_cadastrar');
	}

	public function cadastrando() {
		$id = $this->model_cad_estados->cadastrando();
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Novo cadastro', 'cad_estados', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso', 'descricao' => 'Seu cadastro foi realizado.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function alterar($id) {
		$dados['id']					= $id;
		$dados['cad_estados'] = $this->model_cad_estados->alterar($id);
		$dados['logs']				= $this->dataHelper->DH_getLogFile('cad_estados', 'item_' . $id);

		$this->dataHelper->DH_actionRecord($id);
		$this->_cms('Modules\Cad_estados\Views\view_cad_estados_cadastrar', $dados);
	}

	public function alterando($id) {
		$this->model_cad_estados->alterando($id);
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'cad_estados', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function deletar($id) {
		$dados = $this->model_cad_estados->alterar($id);
		
		$this->model_cad_estados->deletar($id);
		$this->dataHelper->DH_createLogFile($id, $dados, 'Exclusão de cadastro', 'cad_estados', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1)));
	}
}
