<?php 
if(service('request')->uri->getSegment(2) == "novo-cadastro") { 
	echo form_open_multipart($MyMod . "/cadastrando", array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
else { 
	echo form_open_multipart($MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
?>

<div class="wrapper wrapper-content animated fadeInRight">
	<?php echo view('Views\view_header'); ?>

	<?php if(isset($cad_estados->data_cadastro) AND !empty($cad_estados->data_cadastro)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_estados->data_cadastro)); ?> </b>
						
						<?php if(isset($cad_estados->data_alteracao) AND !empty($cad_estados->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_estados->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>Formulário de cadastro</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="ativo" class="form-label">
								Status:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="ativo">
									<i class="fa-light fa-power-off"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="ativo" name="ativo">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cad_estados->ativo) and $cad_estados->ativo == 1) { echo 'selected'; } ?> value="1">Cadastro ativo</option>
									<option <?php if(isset($cad_estados->ativo) and $cad_estados->ativo == 0) { echo 'selected'; } ?> value="0">Cadastro inativo</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="uf" class="form-label">
								UF:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="uf">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="uf" aria-describedby="uf" data-rule-required="true" data-msg-required="Campo obrigatório." id="uf" name="uf" value="<?php if(isset($cad_estados->uf)) { echo $cad_estados->uf; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="titulo" class="form-label">
								Título:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="titulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="titulo" aria-describedby="titulo" data-rule-required="true" data-msg-required="Campo obrigatório." id="titulo" name="titulo" value="<?php if(isset($cad_estados->titulo)) { echo $cad_estados->titulo; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="latitude" class="form-label">
								Latitude:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="latitude">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="latitude" aria-describedby="latitude" data-rule-required="true" data-msg-required="Campo obrigatório." id="latitude" name="latitude" value="<?php if(isset($cad_estados->latitude)) { echo $cad_estados->latitude; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="longitude" class="form-label">
								Longitude:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="longitude">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="longitude" aria-describedby="longitude" data-rule-required="true" data-msg-required="Campo obrigatório." id="longitude" name="longitude" value="<?php if(isset($cad_estados->longitude)) { echo $cad_estados->longitude; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-lg-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>Mapa</h5>
				</div>

				<div class="ibox-content">
					<div class="row pl-3 pr-3 pt-3 pb-3">
						<div class="col-sm-12">

							<?php if(isset($cad_estados->id) AND !empty($cad_estados->id)) { ?>
								<div id="mapa" class="mapa-estado" style="width: 100%; height: 450px;"></div>
							<?php } else { ?> 
								<center>
									<h3 class="m-0">Salve os dados para ver o mapa</h3>
								</center>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<?php echo view('Views\view_footer'); ?>
<?php echo form_close(); ?>