<?php
namespace Modules\Cad_galeria\Controllers;

use App\Controllers\BaseController;
use Modules\Cad_galeria\Models\model_cad_galeria;

class Cad_galeria extends BaseController {
	public function __construct() {
		$this->model_cad_galeria = new Model_cad_galeria;
	}

	public function index() {
	}
	
	public function listagem() {
		$dados['cadastros'] = $this->model_cad_galeria->getCadastros();

		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_galeria\Views\view_cad_galeria_listar', $dados);
	}

	public function cadastrar() {
		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_galeria\Views\view_cad_galeria_cadastrar');
	}

	public function cadastrando() {
		$url                    = strtolower($this->dataHelper->DH_cleanString(service('request')->getPost('titulo')));
		$urlAmigavel            = $this->dataHelper->DH_checkDuplicate('cad_galeria', 'url_amigavel', $url);
		$_POST['url_amigavel']  = $urlAmigavel;
		
		$id = $this->model_cad_galeria->cadastrando();

		if(isset($_FILES['imagem']) and $_FILES['imagem']['error'] == 0) {
			$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_galeria', '', 'upload_cad_galeria', 'item_' . $id, 'imagem', $id);
			$this->dataHelper->DH_actionRecordUpload('cad_galeria', $id, $fileReturn['msg']);
		}

		if(isset($_FILES['banner']) and $_FILES['banner']['error'] == 0) {
			$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_galeria', '', 'upload_cad_galeria', 'item_' . $id, 'banner', $id);
			$this->dataHelper->DH_actionRecordUpload('cad_galeria', $id, $fileReturn['msg']);
		}

		$this->dataHelper->DH_createLogFile($id, $_POST, 'Novo cadastro', 'cad_galeria', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso', 'descricao' => 'Seu cadastro foi realizado.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function alterar($id) {
		$dados['id']				= $id;
		$dados['cadastro'] 	= $this->model_cad_galeria->alterar($id);
		$dados['logs']			= $this->dataHelper->DH_getLogFile('cad_galeria', 'item_' . $id);

		$this->dataHelper->DH_actionRecord($id);
		$this->_cms('Modules\Cad_galeria\Views\view_cad_galeria_cadastrar', $dados);
	}

	public function alterando($id) {
		$dados = $this->model_cad_galeria->alterar($id);

		/*
    * Remove valores do POST
    */

		unset($_POST['honeypot']);
		unset($_POST['upCadastro']);
		unset($_POST['upModulo']);
		unset($_POST['upTabela']);
		unset($_POST['upPasta']);
		unset($_POST['upSubPasta']);
		unset($_POST['upIndex']);
		unset($_POST['uploaderGallery_count']);
		

		for ($i = 0; $i <= 20; $i++) { 
			unset($_POST['uploaderGallery_' . $i . '_status']);
			unset($_POST['uploaderGallery_' . $i . '_tmpname']);
			unset($_POST['uploaderGallery_' . $i . '_name']);
		}

		if(isset($_FILES['imagem']) and $_FILES['imagem']['error'] == 0) {
			$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_galeria', $dados->imagem, 'upload_cad_galeria', 'item_' . $id, 'imagem', $id);
			$this->dataHelper->DH_actionRecordUpload('cad_galeria', $id, $fileReturn['msg']);
		}

		if(isset($_FILES['banner']) and $_FILES['banner']['error'] == 0) {
			$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_galeria', $dados->banner, 'upload_cad_galeria', 'item_' . $id, 'banner', $id);
			$this->dataHelper->DH_actionRecordUpload('cad_galeria', $id, $fileReturn['msg']);
		}
		
		$url                    = strtolower($this->dataHelper->DH_cleanString(service('request')->getPost('titulo')));
		$urlAmigavel            = $this->dataHelper->DH_checkDuplicate('cad_galeria', 'url_amigavel', $url, $dados->id);
		$_POST['url_amigavel']  = $urlAmigavel;

		$this->model_cad_galeria->alterando($id);
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'cad_galeria', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function deletar($id) {
		$dados = $this->model_cad_galeria->alterar($id);

		$this->model_cad_galeria->deletar($id);
		$this->dataHelper->DH_createLogFile($id, $dados, 'Exclusão de cadastro', 'cad_galeria', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1)));
	}
}