<?php 
if(service('request')->uri->getSegment(2) == "novo-cadastro") { 
	echo form_open_multipart($MyMod . "/cadastrando", array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
else { 
	echo form_open_multipart($MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); 
} 

$imagemLargura 	= "80px";
$imagemAltura 	= "80px";
?>

<div class="wrapper wrapper-content animated fadeInUp">
	<?php echo view('Views\view_header'); ?>

	<?php if(isset($cadastro->data_cadastro) AND !empty($cadastro->data_cadastro)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($cadastro->data_cadastro)); ?> </b>
						
						<?php if(isset($cadastro->data_alteracao) AND !empty($cadastro->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($cadastro->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Texto da página inicial
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="ativo" class="form-label">
								Status:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="ativo">
									<i class="fa-light fa-power-off"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="ativo" name="ativo">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cadastro->ativo) and $cadastro->ativo == 1) { echo 'selected'; } ?> value="1">Cadastro ativo</option>
									<option <?php if(isset($cadastro->ativo) and $cadastro->ativo == 0) { echo 'selected'; } ?> value="0">Cadastro inativo</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="titulo" class="form-label">
								Título:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="titulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="titulo" aria-describedby="titulo" data-rule-required="true" data-msg-required="Campo obrigatório." id="titulo" name="titulo" value="<?php if(isset($cadastro->titulo)) { echo $cadastro->titulo; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title d-none">
					<h5>
						Imagem
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-6 border-end">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Imagem:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-desktop"> Largura <b>Qualquer</b> e altura <b>Qualquer</b></span>
							</label>

							<?php if(isset($cadastro->imagem) and $cadastro->imagem) { ?>
								<a href="<?php echo PUBLICURL . 'uploads/upload_cad_galeria/item_' . $cadastro->id . '/' . $cadastro->imagem; ?>" data-gallery="gallery-logos" data-title="<?php if(isset($cadastro->titulo) and $cadastro->titulo) { echo $cadastro->titulo; } ?>">
									<center class="center-img">
										<img class="img-responsive" src="<?php echo PUBLICURL . 'uploads/upload_cad_galeria/item_' . $cadastro->id . '/' . $cadastro->imagem; ?>"/>
									</center>
								</a>										
							<?php } ?>
						</div>

						<div class="col-6">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Preview:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-desktop"> Largura <b>Qualquer</b> e altura <b>Qualquer</b></span>
							</label>

							<center class="center-preview-img">
								<div class="image-preview" id="image-preview"></div>
							</center>

							<label title="Selecione a imagem." for="imagem" class="btn btn-primary w-100 mt-3">
								<input type="file" accept="image/*" name="imagem" id="imagem" data-holder="image-preview" class="d-none btn-imagem-preview">
								<i class="fa-light fa-image"></i> Selecionar imagem
							</label>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title d-none">
					<h5>
						Banner
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-6 border-end">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Banner:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-desktop"> Largura <b>Qualquer</b> e altura <b>Qualquer</b></span>
							</label>

							<?php if(isset($cadastro->banner) and $cadastro->banner) { ?>
								<a href="<?php echo PUBLICURL . 'uploads/upload_cad_galeria/item_' . $cadastro->id . '/' . $cadastro->banner; ?>" data-gallery="gallery-logos" data-title="<?php if(isset($cadastro->titulo) and $cadastro->titulo) { echo $cadastro->titulo; } ?>">
									<center class="center-img">
										<img class="img-responsive" src="<?php echo PUBLICURL . 'uploads/upload_cad_galeria/item_' . $cadastro->id . '/' . $cadastro->banner; ?>"/>
									</center>
								</a>										
							<?php } ?>
						</div>

						<div class="col-6">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Preview:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-desktop"> Largura <b>Qualquer</b> e altura <b>Qualquer</b></span>
							</label>

							<center class="center-preview-img">
								<div class="image-preview" id="banner-preview"></div>
							</center>

							<label title="Selecione a imagem." for="banner" class="btn btn-primary w-100 mt-3">
								<input type="file" accept="image/*" name="banner" id="banner" data-holder="banner-preview" class="d-none btn-imagem-preview">
								<i class="fa-light fa-image"></i> Selecionar imagem
							</label>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- 
	---- Galeria
	--->

	<?php if(isset($cadastro->id) AND !empty($cadastro->id)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<h5>
							Upload de imagens
						</h5>
					</div>

					<div class="ibox-content">
						<div class="formRow">
							<div class="mt-0">
								<input type="hidden" class="upCadastro" name="upCadastro"	 	value="<?php echo $cadastro->id; ?>">
								<input type="hidden" class="upModulo" 	name="upModulo"	 		value="cad_galeria">
								<input type="hidden" class="upTabela" 	name="upTabela"	 		value="cad_galeria">
								<input type="hidden" class="upPasta" 		name="upPasta"	 		value="upload_cad_galeria">
								<input type="hidden" class="upSubPasta" name="upSubPasta"	 	value="item_<?php echo $cadastro->id; ?>">
								<input type="hidden" class="upIndex" 		name="upIndex"	 		value="galeria">

								<div id="uploaderGallery"></div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<h5>
							Galeria de imagens
						</h5>
					</div>

					<div class="ibox-content">
						<div class="lightBoxGallery clearfix">
							<div class="row">
								<?php if(isset($cadastro) AND !empty($cadastro->galeria)) { ?>

									<?php $galeria = unserialize($cadastro->galeria); ?>

									<?php foreach($galeria as $key => $valor) { ?>

										<?php  
										if(isset($valor['ordem']) AND !empty($valor['ordem'])) {
											$ord = $valor['ordem'];
										}
										else {
											$ord = 0;
										}
										?>

										<div class="col-3 mt-4">
											<div class="img-background img-background-<?php echo $key; ?> border w-100">
												<a class="link-galeria" href="<?php echo PUBLICURL . 'uploads/upload_cad_galeria/item_' . $cadastro->id . '/' . $valor['imagem']; ?>" data-gallery="gallery-imgs">
													<img class="img-galeria" src="<?php echo PUBLICURL . 'uploads/upload_cad_galeria/item_' . $cadastro->id . '/' . $valor['imagem']; ?>">
												</a>

												<?php  
												$dataAttr = "";
												$dataAttr .= "data-key					= '" . $key . "' ";
												$dataAttr .= "data-upcadastro		= '" . $cadastro->id . "' ";
												$dataAttr .= "data-upmodulo			= 'cad_galeria' ";
												$dataAttr .= "data-uptabela			= 'cad_galeria' ";
												$dataAttr .= "data-uppasta			= 'upload_cad_galeria' ";
												$dataAttr .= "data-upsubpasta		= 'item_" . $cadastro->id . "' ";
												$dataAttr .= "data-upindex			= 'galeria' ";
												$dataAttr .= "data-upimagem			= '" . $valor['imagem'] . "' ";
												?>

												<div class="input-group mt-2 mb-2">
													<label class="d-block w-100 text-start">Ordem: </label>
													<input type="text" class="form-control input-order-<?php echo $key; ?>" value="<?php echo $ord; ?>">
													<span class="input-group-append"> 
														<button type="button" class="btn btn-primary saveNewOrder saveNewOrder-<?php echo $key; ?>" <?php echo $dataAttr; ?>> 
															<i class="fa-light fa-save"></i>
														</button> 
													</span>
												</div>

												<div class="input-group mb-2">
													<label class="d-block w-100 text-start">Título: </label>
													<input type="text" class="form-control input-name-<?php echo $key; ?>" value="<?php echo $valor['titulo']; ?>">
													<span class="input-group-append"> 
														<button type="button" class="btn btn-primary saveImagemName saveImagemName-<?php echo $key; ?>"<?php echo $dataAttr; ?>> 
															<i class="fa-light fa-save"></i>
														</button> 
													</span>
												</div>

												<div class="input-group">
													<label class="d-block w-100 text-start">Descrição: </label>
													<textarea type="text" class="form-control input-description-<?php echo $key; ?>" rows="5"><?php if(isset($valor['descricao']) AND !empty($valor['descricao'])) { echo $valor['descricao']; } ?></textarea>
													<span class="input-group-append"> 
														<button type="button" class="btn btn-primary saveImagemDescripiton saveImagemDescripiton-<?php echo $key; ?>"<?php echo $dataAttr; ?>> 
															<i class="fa-light fa-save"></i>
														</button> 
													</span>
												</div>

												<div class="actions">
													<a title="" href="#" class="deleteImagemGallery" <?php echo $dataAttr; ?>>
														<i class="fa-light fa-trash text-danger"></i>
													</a>
												</div>
											</div>
										</div>
									<?php } ?>

								<?php } ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div> 
	<?php } else { ?> 
		<div class="row" style="margin-bottom: 25px;">
			<div class="col-12">
				<div class="alert alert-danger mb-0">
					<i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Para ter acesso a <b>Galeria de Imagens,</b> salve os dados primeiro. 
				</div>
			</div>
		</div>
	<?php } ?>

	<?php echo view('Views\view_logs'); ?>
</div>

<?php echo view('Views\view_footer'); ?>
<?php echo form_close(); ?>