<?php
namespace Modules\Cad_institucional\Controllers;

use App\Controllers\BaseController;
use Modules\Cad_institucional\Models\model_cad_institucional;

class Cad_institucional extends BaseController {
	public function __construct() {
		$this->model_cad_institucional = new Model_cad_institucional;
	}

	public function index() {
		$dados['id']         				= 1;
		$dados['cad_institucional'] = $this->model_cad_institucional->alterar();
		$dados['conf_ajustes']			= $this->dataHelper->DH_getAjustes();
		$dados['logs']							= $this->dataHelper->DH_getLogFile('cad_institucional', '');

		$this->dataHelper->DH_actionRecord(1);
		$this->_cms('Modules\Cad_institucional\Views\view_cad_institucional_cadastrar', $dados);
	}

	public function alterando() {
		
		/*
    * Remove valores do POST
    */

		unset($_POST['honeypot']);
		unset($_POST['upCadastro']);
		unset($_POST['upModulo']);
		unset($_POST['upTabela']);
		unset($_POST['upPasta']);
		unset($_POST['upSubPasta']);
		unset($_POST['upIndex']);
		unset($_POST['uploaderGallery_count']);
		
		for ($i = 0; $i <= 20; $i++) { 
			unset($_POST['uploaderGallery_' . $i . '_status']);
			unset($_POST['uploaderGallery_' . $i . '_tmpname']);
			unset($_POST['uploaderGallery_' . $i . '_name']);
		}

		$dados = $this->model_cad_institucional->alterar();

		/*
		* WhatsApp
		*/

		if(isset($_POST['whatsapp_titulo']) AND !empty($_POST['whatsapp_titulo'])) {
			$array   = array();
			$titulos = $_POST['whatsapp_titulo'];

			foreach ($titulos as $key => $titulo) {
				$arrayPush = array(
					"titulo" 	=> $titulo,
					"numero" 	=> $_POST['whatsapp_numero'][$key],
					"frase" 	=> $_POST['whatsapp_frase'][$key]
				);

				array_push($array, $arrayPush);
			}

			unset($_POST['whatsapp_titulo']);
			unset($_POST['whatsapp_numero']);
			unset($_POST['whatsapp_frase']);

			$_POST['whatsapp'] = serialize($array);
		}
		else {
			$_POST['whatsapp'] = "";	
		}

    /*
    * Uploads images
    */

    if(isset($_FILES['imagem']) and $_FILES['imagem']['error'] == 0) {
    	$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_institucional', $dados->imagem, 'upload_cad_institucional', '', 'imagem', $dados->id);
    	$this->dataHelper->DH_actionRecordUpload('cad_institucional', $dados->id, $fileReturn['msg']);
    }

    if(isset($_FILES['subimagem']) and $_FILES['subimagem']['error'] == 0) {
    	$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_institucional', $dados->subimagem, 'upload_cad_institucional', '', 'subimagem', $dados->id);
    	$this->dataHelper->DH_actionRecordUpload('cad_institucional', $dados->id, $fileReturn['msg']);
    }

    /*
    * Favicon
    */

    if(isset($_FILES['favicon']) and $_FILES['favicon']['error'] == 0) {
    	$_POST['favicon'] = $this->uploadHelper->UPH_uploadFavicon($dados->favicon, 'upload_cad_favicon', $dados->id);
    }

    $this->model_cad_institucional->alterando();
    $this->dataHelper->DH_createLogFile($dados->id, $_POST, 'Alteração de cadastro', 'cad_institucional', '');
    $this->dataHelper->DH_actionRecord($dados->id);
    
    service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
    return redirect()->to(BASECMSURL . service('request')->uri->getSegment(1));
  }
}