<?php echo form_open_multipart(BASECMSURL . $MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); ?>

<div class="wrapper wrapper-content animated fadeInUp">
	<?php echo view('Views\view_header'); ?>

	<?php if(isset($cad_institucional->data_cadastro) AND !empty($cad_institucional->data_cadastro)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_institucional->data_cadastro)); ?> </b>
						
						<?php if(isset($cad_institucional->data_alteracao) AND !empty($cad_institucional->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_institucional->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<!-- 
	---- Status do site
	--->

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Status do site
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="ativo" class="form-label">
								Status do projeto <span class="text-danger">(não afeta o CMS)</span>:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="ativo">
									<i class="fa-light fa-power-off"></i>
								</label>

								<select class="form-select" name="ativo" id="ativo">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cad_institucional->ativo) and $cad_institucional->ativo == 1) { echo 'selected'; } ?> value="1">Online</option>
									<option <?php if(isset($cad_institucional->ativo) and $cad_institucional->ativo == 0) { echo 'selected'; } ?> value="0">Offline</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="manutencao_texto" class="form-label">
								Mensagem de manutenção <span class="text-danger">(esta mensagem irá ser apresentada quando o site estiver em manutençao)</span>:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="manutencao_texto">
									<i class="fa-light fa-align-left"></i>
								</span>

								<textarea class="form-control" cols="80" rows="5" id="manutencao_texto" name="manutencao_texto"><?php if(isset($cad_institucional->manutencao_texto)) { echo $cad_institucional->manutencao_texto; } ?></textarea>
							</div>
						</div>

						<div class="col-12">
							<label for="redirecionamento" class="form-label">
								Link de redirecionamento:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="redirecionamento">
									<i class="fa-light fa-link"></i>
								</span>

								<input type="text" class="form-control" aria-label="redirecionamento" aria-describedby="redirecionamento" id="redirecionamento" name="redirecionamento" value="<?php if(isset($cad_institucional->redirecionamento)) { echo $cad_institucional->redirecionamento; } ?>">
							</div>
						</div>

						<div class="col-12 mb-3">
							<label for="manutencao_cor_fundo" class="form-label">
								Cor do fundo:
							</label>

							<input type="color" class="form-control form-control-color" aria-label="manutencao_cor_fundo" aria-describedby="manutencao_cor_fundo" data-rule-required="true" data-msg-required="Campo obrigatório." id="manutencao_cor_fundo" name="manutencao_cor_fundo" value="<?php if(isset($cad_institucional->manutencao_cor_fundo)) { echo $cad_institucional->manutencao_cor_fundo; } ?>">
						</div>

						<div class="col-12 mb-0">
							<label for="manutencao_cor_texto" class="form-label">
								Cor do texto:
							</label>

							<input type="color" class="form-control form-control-color" aria-label="manutencao_cor_texto" aria-describedby="manutencao_cor_texto" data-rule-required="true" data-msg-required="Campo obrigatório." id="manutencao_cor_texto" name="manutencao_cor_texto" value="<?php if(isset($cad_institucional->manutencao_cor_texto)) { echo $cad_institucional->manutencao_cor_texto; } ?>">
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- 
	---- Dados de Cadastro 
	--->

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Formulário de cadastro
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="titulo" class="form-label">
								Título:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="titulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="titulo" aria-describedby="titulo" required data-msg-required="Campo obrigatório" id="titulo" name="titulo" value="<?php if(isset($cad_institucional->titulo)) { echo $cad_institucional->titulo; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="subtitulo" class="form-label">
								Subtitulo:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="subtitulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="subtitulo" aria-describedby="subtitulo" required data-msg-required="Campo obrigatório" id="subtitulo" name="subtitulo" value="<?php if(isset($cad_institucional->subtitulo)) { echo $cad_institucional->subtitulo; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="cnpj" class="form-label">
								CNPJ:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="cnpj">
									<i class="fa-light fa-hashtag"></i>
								</span>

								<input type="text" class="form-control mask-cnpj" aria-label="cnpj" aria-describedby="cnpj" id="cnpj" name="cnpj" value="<?php if(isset($cad_institucional->cnpj)) { echo $cad_institucional->cnpj; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="fundacao" class="form-label">
								Data da Fundação:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="fundacao">
									<i class="fa-light fa-calendar-alt"></i>
								</span>

								<input type="text" class="form-control" aria-label="fundacao" aria-describedby="fundacao" id="fundacao" name="fundacao" value="<?php if(isset($cad_institucional->fundacao)) { echo $cad_institucional->fundacao; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- 
	---- Dados de Cadastro 
	--->

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Formulário de cadastro
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="atendimento_data" class="form-label">
								Atendimento ( data ):
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="atendimento_data">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="atendimento_data" aria-describedby="atendimento_data" required data-msg-required="Campo obrigatório" id="atendimento_data" name="atendimento_data" value="<?php if(isset($cad_institucional->atendimento_data)) { echo $cad_institucional->atendimento_data; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="atendimento_hora" class="form-label">
								Atendimento ( horário ):
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="atendimento_hora">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="atendimento_hora" aria-describedby="atendimento_hora" required data-msg-required="Campo obrigatório" id="atendimento_hora" name="atendimento_hora" value="<?php if(isset($cad_institucional->atendimento_hora)) { echo $cad_institucional->atendimento_hora; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- 
	---- Endereço 
	--->
	
	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Endereço
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12 col-lg-6">
							<label for="estado" class="form-label">
								Estado:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="estado">
									<i class="fa-light fa-location-dot"></i>
								</span>

								<input type="text" class="form-control" aria-label="estado" aria-describedby="estado" id="estado" name="estado" value="<?php if(isset($cad_institucional->estado)) { echo $cad_institucional->estado; } ?>">
							</div>
						</div>

						<div class="col-12 col-lg-6">
							<label for="cidade" class="form-label">
								Cidade:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="cidade">
									<i class="fa-light fa-location-dot"></i>
								</span>

								<input type="text" class="form-control" aria-label="cidade" aria-describedby="cidade" id="cidade" name="cidade" value="<?php if(isset($cad_institucional->cidade)) { echo $cad_institucional->cidade; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="bairro" class="form-label">
								Bairro:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="bairro">
									<i class="fa-light fa-location-dot"></i>
								</span>

								<input type="text" class="form-control" aria-label="bairro" aria-describedby="bairro" id="bairro" name="bairro" value="<?php if(isset($cad_institucional->bairro)) { echo $cad_institucional->bairro; } ?>">
							</div>
						</div>

						<div class="col-12 col-lg-9">
							<label for="endereco" class="form-label">
								Endereço:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="endereco">
									<i class="fa-light fa-road"></i>
								</span>

								<input type="text" class="form-control" aria-label="endereco" aria-describedby="endereco" id="endereco" name="endereco" value="<?php if(isset($cad_institucional->endereco)) { echo $cad_institucional->endereco; } ?>">
							</div>
						</div>

						<div class="col-12 col-lg-3">
							<label for="endereco_numero" class="form-label">
								Número:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="endereco_numero">
									<i class="fa-light fa-hashtag"></i>
								</span>

								<input type="text" class="form-control" aria-label="endereco_numero" aria-describedby="endereco_numero" id="endereco_numero" name="endereco_numero" value="<?php if(isset($cad_institucional->endereco_numero)) { echo $cad_institucional->endereco_numero; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="endereco_complemento" class="form-label">
								Complemento:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="endereco_complemento">
									<i class="fa-light fa-map-marker-plus"></i>
								</span>

								<input type="text" class="form-control" aria-label="endereco_complemento" aria-describedby="endereco_complemento" id="endereco_complemento" name="endereco_complemento" value="<?php if(isset($cad_institucional->endereco_complemento)) { echo $cad_institucional->endereco_complemento; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="cep" class="form-label">
								CEP:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="cep">
									<i class="fa-light fa-location-dot"></i>
								</span>

								<input type="text" class="form-control mask-cep" aria-label="cep" aria-describedby="cep" id="cep" name="cep" value="<?php if(isset($cad_institucional->cep)) { echo $cad_institucional->cep; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- 
	---- Coordenadas 
	--->
	
	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<a href="https://www.mapcoordinates.net/pt" target="_blank" class="text-navy">Clique aqui</a> para descobrir as coordenadas de uma localização no Google Maps.
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Coordenadas
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12 col-lg-6">
							<label for="latitude" class="form-label">
								Latitude:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="latitude">
									<i class="fa-light fa-location-dot"></i>
								</span>

								<input type="text" class="form-control" aria-label="latitude" aria-describedby="latitude" id="latitude" name="latitude" value="<?php if(isset($cad_institucional->latitude)) { echo $cad_institucional->latitude; } ?>">
							</div>
						</div>

						<div class="col-12 col-lg-6">
							<label for="longitude" class="form-label">
								Longitude:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="longitude">
									<i class="fa-light fa-location-dot"></i>
								</span>

								<input type="text" class="form-control" aria-label="longitude" aria-describedby="longitude" id="longitude" name="longitude" value="<?php if(isset($cad_institucional->longitude)) { echo $cad_institucional->longitude; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-lg-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>Mapa</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">

							<?php if(isset($cad_institucional->id) AND !empty($cad_institucional->id)) { ?>
								<div id="mapa" class="rounded-3" style="width:100%; height:450px;"></div>
							<?php } else { ?> 
								<center>
									<h3 class="m-0">Salve os dados para ver o mapa</h3>
								</center>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- 
	---- Contatos 
	--->

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Contatos
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="email" class="form-label">
								E-mail:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="email">
									<i class="fa-light fa-at"></i>
								</span>

								<input type="text" class="form-control" aria-label="email" aria-describedby="email" id="email" name="email" value="<?php if(isset($cad_institucional->email)) { echo $cad_institucional->email; } ?>">
							</div>
						</div>

						<div class="col-12 col-lg-6">
							<label for="contato_fixo_um" class="form-label">
								Telefone fixo #01:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="contato_fixo_um">
									<i class="fa-light fa-phone-rotary"></i>
								</span>

								<input type="text" class="form-control mask-phone" aria-label="contato_fixo_um" aria-describedby="contato_fixo_um" id="contato_fixo_um" name="contato_fixo_um" value="<?php if(isset($cad_institucional->contato_fixo_um)) { echo $cad_institucional->contato_fixo_um; } ?>">
							</div>
						</div>

						<div class="col-12 col-lg-6">
							<label for="contato_fixo_dois" class="form-label">
								Teleone fixo #02:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="contato_fixo_dois">
									<i class="fa-light fa-phone-rotary"></i>
								</span>

								<input type="text" class="form-control mask-phone" aria-label="contato_fixo_dois" aria-describedby="contato_fixo_dois" id="contato_fixo_dois" name="contato_fixo_dois" value="<?php if(isset($cad_institucional->contato_fixo_dois)) { echo $cad_institucional->contato_fixo_dois; } ?>">
							</div>
						</div>

						<div class="col-12 col-lg-6">
							<label for="contato_celular_um" class="form-label">
								Celular #01:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="contato_celular_um">
									<i class="fa-light fa-mobile"></i>
								</span>

								<input type="text" class="form-control mask-phone" aria-label="contato_celular_um" aria-describedby="contato_celular_um" id="contato_celular_um" name="contato_celular_um" value="<?php if(isset($cad_institucional->contato_celular_um)) { echo $cad_institucional->contato_celular_um; } ?>">
							</div>
						</div>

						<div class="col-12 col-lg-6">
							<label for="contato_celular_dois" class="form-label">
								Celular #02:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="contato_celular_dois">
									<i class="fa-light fa-mobile"></i>
								</span>

								<input type="text" class="form-control mask-phone" aria-label="contato_celular_dois" aria-describedby="contato_celular_dois" id="contato_celular_dois" name="contato_celular_dois" value="<?php if(isset($cad_institucional->contato_celular_dois)) { echo $cad_institucional->contato_celular_dois; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- 
	---- Whats App 
	--->

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						WhatsApp
					</h5>

					<div class="ibox-tools">
						
					</div>
				</div>

				<div class="ibox-content ibox-content-whatsapp">
					<?php 
					if(isset($cad_institucional->whatsapp) AND !empty($cad_institucional->whatsapp)) {
						$whatsapps 	= unserialize($cad_institucional->whatsapp);
						$viewPath 	= "Modules\\Cad_institucional\\Views\\view_cad_institucional_whatsapp";

						foreach ($whatsapps as $key => $whats) { 
							$data = ['num' => $key, 'whats' => $whats];
							echo view($viewPath, $data);
						} 
					}
					?>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins mb-4">
				<div class="ibox-title p-3">
					<button type="button" class="btn btn-success m-0 w-100 btn-add-whatsapp">
						<i class="fa-light fa-plus"></i>
						Adicionar novo número
					</button>
				</div>
			</div>
		</div>
	</div>

	<!-- 
	---- Redes Sociais 
	--->

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Redes Sociais
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12 col-lg-6">
							<label for="facebook" class="form-label">
								Facebook:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="facebook">
									<i class="fa-brands fa-facebook-f"></i>
								</span>

								<input type="text" class="form-control" aria-label="facebook" aria-describedby="facebook" id="facebook" name="facebook" value="<?php if(isset($cad_institucional->facebook)) { echo $cad_institucional->facebook; } ?>">
							</div>
						</div>

						<div class="col-12 col-lg-6">
							<label for="instagram" class="form-label">
								Instagram:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="instagram">
									<i class="fa-brands fa-instagram"></i>
								</span>

								<input type="text" class="form-control" aria-label="instagram" aria-describedby="instagram" id="instagram" name="instagram" value="<?php if(isset($cad_institucional->instagram)) { echo $cad_institucional->instagram; } ?>">
							</div>
						</div>

						<div class="col-12 col-lg-6 d-none">
							<label for="linkedin" class="form-label">
								LinkedIn:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="linkedin">
									<i class="fa-brands fa-linkedin-in"></i>
								</span>

								<input type="text" class="form-control" aria-label="linkedin" aria-describedby="linkedin" id="linkedin" name="linkedin" value="<?php if(isset($cad_institucional->linkedin)) { echo $cad_institucional->linkedin; } ?>">
							</div>
						</div>

						<div class="col-12 col-lg-6 d-none">
							<label for="twitter" class="form-label">
								Twitter:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="twitter">
									<i class="fa-brands fa-twitter"></i>
								</span>

								<input type="text" class="form-control" aria-label="twitter" aria-describedby="twitter" id="twitter" name="twitter" value="<?php if(isset($cad_institucional->twitter)) { echo $cad_institucional->twitter; } ?>">
							</div>
						</div>

						<div class="col-12 col-lg-6 d-none">
							<label for="youtube" class="form-label">
								YouTube:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="youtube">
									<i class="fa-brands fa-youtube"></i>
								</span>

								<input type="text" class="form-control" aria-label="youtube" aria-describedby="youtube" id="youtube" name="youtube" value="<?php if(isset($cad_institucional->youtube)) { echo $cad_institucional->youtube; } ?>">
							</div>
						</div>

						<div class="col-12 col-lg-6 d-none">
							<label for="tiktok" class="form-label">
								TikTok:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="tiktok">
									<i class="fa-brands fa-tiktok"></i>
								</span>

								<input type="text" class="form-control" aria-label="tiktok" aria-describedby="tiktok" id="tiktok" name="tiktok" value="<?php if(isset($cad_institucional->tiktok)) { echo $cad_institucional->tiktok; } ?>">
							</div>
						</div>

						<div class="col-12 col-lg-6 d-none">
							<label for="pinterest" class="form-label">
								Pintrest:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="pinterest">
									<i class="fa-brands fa-pinterest-p"></i>
								</span>

								<input type="text" class="form-control" aria-label="pinterest" aria-describedby="pinterest" id="pinterest" name="pinterest" value="<?php if(isset($cad_institucional->pinterest)) { echo $cad_institucional->pinterest; } ?>">
							</div>
						</div>

						<div class="col-12 col-lg-6 d-none">
							<label for="twitch" class="form-label">
								Twitch:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="twitch">
									<i class="fa-brands fa-twitch"></i>
								</span>

								<input type="text" class="form-control" aria-label="twitch" aria-describedby="twitch" id="twitch" name="twitch" value="<?php if(isset($cad_institucional->twitch)) { echo $cad_institucional->twitch; } ?>">
							</div>
						</div>

						<div class="col-12 col-lg-6 d-none">
							<label for="discord" class="form-label">
								Discord:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="discord">
									<i class="fa-brands fa-discord"></i>
								</span>

								<input type="text" class="form-control" aria-label="discord" aria-describedby="discord" id="discord" name="discord" value="<?php if(isset($cad_institucional->discord)) { echo $cad_institucional->discord; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- 
	---- Logos 
	--->

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Logos
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12 col-lg-6 border-end">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Logo do topo:
							</label>

							<br>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: Largura <b><?php echo $conf_ajustes->logo_topo_width . 'px'; ?></b> e altura <b><?php echo $conf_ajustes->logo_topo_height . 'px'; ?></b>
							</label>

							<?php if(isset($cad_institucional->imagem) and $cad_institucional->imagem) { ?>
								<a href="<?php echo PUBLICURL . 'uploads/upload_cad_institucional/' . $cad_institucional->imagem; ?>" data-gallery="gallery-logos" data-title="<?php if(isset($cad_institucional->titulo) and $cad_institucional->titulo) { echo $cad_institucional->titulo; } ?>">
									<center class="center-img">
										<img class="img-responsive" src="<?php echo PUBLICURL . 'uploads/upload_cad_institucional/' . $cad_institucional->imagem; ?>"/>
									</center>
								</a>										
							<?php } ?>

							<label class="mt-4 mb-2">
								<i class="fa-light fa-image"></i> Preview:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: Largura <b><?php echo $conf_ajustes->logo_topo_width . 'px'; ?></b> e altura <b><?php echo $conf_ajustes->logo_topo_height . 'px'; ?></b>
							</label>

							<center class="center-preview-img-below">
								<div class="image-preview" id="image-preview"></div>
							</center>

							<label title="Selecione a imagem." for="imagem" class="btn btn-primary w-100">
								<input type="file" accept="image/*" name="imagem" id="imagem" data-holder="image-preview" class="btn-imagem-preview" <?php if(empty($cad_institucional->imagem)) { echo ''; } ?>>
								<i class="fa-light fa-image"></i> Selecionar logo do topo
							</label>
						</div>

						<div class="col-12 col-lg-6 mt-4 mt-lg-0">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Logo do rodapé:
							</label>

							<br>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: Largura <b><?php echo $conf_ajustes->logo_rodape_width . 'px'; ?></b> e altura <b><?php echo $conf_ajustes->logo_rodape_height . 'px'; ?></b>
							</label>

							<?php if(isset($cad_institucional->subimagem) and $cad_institucional->subimagem) { ?>
								<a href="<?php echo PUBLICURL . 'uploads/upload_cad_institucional/' . $cad_institucional->subimagem; ?>" data-gallery="gallery-logos" data-title="<?php if(isset($cad_institucional->titulo) and $cad_institucional->titulo) { echo $cad_institucional->titulo; } ?>">
									<center class="center-img">
										<img src="<?php echo PUBLICURL . 'uploads/upload_cad_institucional/' . $cad_institucional->subimagem; ?>"/>
									</center>
								</a>										
							<?php } ?>

							<label class="mt-4 mb-2">
								<i class="fa-light fa-image"></i> Preview:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: Largura <b><?php echo $conf_ajustes->logo_rodape_width . 'px'; ?></b> e altura <b><?php echo $conf_ajustes->logo_rodape_height . 'px'; ?></b>
							</label>

							<center class="center-preview-img-below">
								<div class="image-preview" id="subimage-preview"></div>
							</center>

							<label title="Selecione a imagem." for="subimagem" class="btn btn-primary w-100">
								<input type="file" accept="image/*" name="subimagem" id="subimagem" data-holder="subimage-preview" class="btn-imagem-preview" <?php if(empty($cad_institucional->subimagem)) { echo ''; } ?>>
								<i class="fa-light fa-image"></i> Selecionar logo do rodapé
							</label>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- 
	---- Favicon 
	--->

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Favicon
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12 col-lg-6 border-end">
							<label class="mb-2">
								<i class="fa-light fa-icons"></i> Favicon
							</label>

							<br>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: Largura <b><?php echo $conf_ajustes->favicon_width . 'px'; ?></b> e altura <b><?php echo $conf_ajustes->favicon_height . 'px'; ?></b>
							</label>

							<?php if(isset($cad_institucional->favicon) and $cad_institucional->favicon) { ?>
								<a href="<?php echo PUBLICURL . 'uploads/upload_cad_favicon/' . $cad_institucional->favicon; ?>" data-gallery="gallery-favicon" data-title="<?php if(isset($cad_institucional->titulo) and $cad_institucional->titulo) { echo $cad_institucional->titulo; } ?>">
									<center class="center-img">
										<img class="img-responsive" src="<?php echo PUBLICURL . 'uploads/upload_cad_favicon/' . $cad_institucional->favicon; ?>"/>
									</center>
								</a>										
							<?php } ?>
						</div>

						<div class="col-12 col-lg-6 mt-4 mt-lg-0">
							<label class="mb-2">
								<i class="fa-light fa-icons"></i> Preview
							</label>

							<br>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: Largura <b><?php echo $conf_ajustes->favicon_width . 'px'; ?></b> e altura <b><?php echo $conf_ajustes->favicon_height . 'px'; ?></b>
							</label>

							<center class="center-preview-img-below">
								<div class="image-preview" id="favicon-preview"></div>
							</center>

							<label title="Selecione a imagem." for="favicon" class="btn btn-primary w-100">
								<input type="file" accept="image/*" name="favicon" id="favicon" data-holder="favicon-preview" class="btn-imagem-preview" <?php if(empty($cad_institucional->favicon)) { echo ''; } ?>>
								<i class="fa-light fa-image"></i> Selecionar imagem para o Favicon
							</label>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php echo view('Views\view_logs'); ?>
</div>

<?php echo view('Views\view_footer'); ?>
<?php echo form_close(); ?>