<?php
$routes->group(
	'cadastro-de-marcas', 
	[
		'namespace' => 'Modules\Cad_marcas\Controllers', 
		'filter' 		=> 'CheckAccessPermission'
	], 
	function ($routes) {
		$routes->get('/', 'Cad_marcas::listagem');

		$routes->match(['get', 'post'], 'novo-cadastro', 'Cad_marcas::cadastrar');
		$routes->post('cadastrando', 'Cad_marcas::cadastrando');
		
		$routes->match(['get', 'post'], 'alterando-cadastro/(:any)', 'Cad_marcas::alterar/$1');
		$routes->post('atualizando-cadastro/(:any)', 'Cad_marcas::alterando/$1');
		
		$routes->get('deletando-cadastro/(:any)', 'Cad_marcas::deletar/$1');
	}
);