<?php
namespace Modules\Cad_marcas\Controllers;

use App\Controllers\BaseController;
use Modules\Cad_marcas\Models\model_cad_marcas;

class Cad_marcas extends BaseController {
	public function __construct() {
		$this->model_cad_marcas = new Model_cad_marcas;
	}

	public function index() {
	}
	
	public function listagem() {
		$dados['cadastros'] = $this->model_cad_marcas->getCadastros();

		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_marcas\Views\view_cad_marcas_listar', $dados);
	}

	public function cadastrar() {
		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_marcas\Views\view_cad_marcas_cadastrar');
	}

	public function cadastrando() {
		$id = $this->model_cad_marcas->cadastrando();

		if(isset($_FILES['imagem']) and $_FILES['imagem']['error'] == 0) {
			$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_marcas', '', 'upload_cad_marcas', 'item_' . $id, 'imagem', $id);
			$this->dataHelper->DH_actionRecordUpload('cad_marcas', $id, $fileReturn['msg']);
		}

		$this->dataHelper->DH_createLogFile($id, $_POST, 'Novo cadastro', 'cad_marcas', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso', 'descricao' => 'Seu cadastro foi realizado.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function alterar($id) {
		$dados['id']				= $id;
		$dados['cadastro'] 	= $this->model_cad_marcas->alterar($id);
		$dados['logs']			= $this->dataHelper->DH_getLogFile('cad_marcas', 'item_' . $id);

		$this->dataHelper->DH_actionRecord($id);
		$this->_cms('Modules\Cad_marcas\Views\view_cad_marcas_cadastrar', $dados);
	}

	public function alterando($id) {
		$dados = $this->model_cad_marcas->alterar($id);

		if(isset($_FILES['imagem']) and $_FILES['imagem']['error'] == 0) {
    	$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_marcas', $dados->imagem, 'upload_cad_marcas', 'item_' . $id, 'imagem', $id);
    	$this->dataHelper->DH_actionRecordUpload('cad_marcas', $id, $fileReturn['msg']);
    }
		
		$this->model_cad_marcas->alterando($id);
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'cad_marcas', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function deletar($id) {
		$dados = $this->model_cad_marcas->alterar($id);

		$this->model_cad_marcas->deletar($id);
		$this->dataHelper->DH_createLogFile($id, $dados, 'Exclusão de cadastro', 'cad_marcas', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1)));
	}
}