<?php 
if(service('request')->uri->getSegment(2) == "novo-cadastro") { 
	echo form_open_multipart($MyMod . "/cadastrando", array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
else { 
	echo form_open_multipart($MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); 
} 

$imagemLargura 	= "80px";
$imagemAltura 	= "80px";
?>

<div class="wrapper wrapper-content animated fadeInUp">
	<?php echo view('Views\view_header'); ?>

	<?php if(isset($cadastro->data_cadastro) AND !empty($cadastro->data_cadastro)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($cadastro->data_cadastro)); ?> </b>
						
						<?php if(isset($cadastro->data_alteracao) AND !empty($cadastro->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($cadastro->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Texto da página inicial
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="ativo" class="form-label">
								Status:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="ativo">
									<i class="fa-light fa-power-off"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="ativo" name="ativo">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cadastro->ativo) and $cadastro->ativo == 1) { echo 'selected'; } ?> value="1">Cadastro ativo</option>
									<option <?php if(isset($cadastro->ativo) and $cadastro->ativo == 0) { echo 'selected'; } ?> value="0">Cadastro inativo</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="titulo" class="form-label">
								Título:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="titulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="titulo" aria-describedby="titulo" data-rule-required="true" data-msg-required="Campo obrigatório." id="titulo" name="titulo" value="<?php if(isset($cadastro->titulo)) { echo $cadastro->titulo; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title d-none">
					<h5>
						Imagem
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-6 border-end">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Imagem:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-desktop"> Largura <b><?php echo $imagemLargura; ?></b> e altura <b><?php echo $imagemAltura; ?></b></span>
							</label>

							<?php if(isset($cadastro->imagem) and $cadastro->imagem) { ?>
								<a href="<?php echo PUBLICURL . 'uploads/upload_cad_marcas/item_' . $cadastro->id . '/' . $cadastro->imagem; ?>" data-gallery="gallery-logos" data-title="<?php if(isset($cadastro->titulo) and $cadastro->titulo) { echo $cadastro->titulo; } ?>">
									<center class="center-img">
										<img class="img-responsive" src="<?php echo PUBLICURL . 'uploads/upload_cad_marcas/item_' . $cadastro->id . '/' . $cadastro->imagem; ?>"/>
									</center>
								</a>										
							<?php } ?>
						</div>

						<div class="col-6">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Preview:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-desktop"> Largura <b><?php echo $imagemLargura; ?></b> e altura <b><?php echo $imagemAltura; ?></b></span>
							</label>

							<center class="center-preview-img">
								<div class="image-preview" id="image-preview"></div>
							</center>

							<label title="Selecione a imagem." for="imagem" class="btn btn-primary w-100 mt-3">
								<input type="file" accept="image/*" name="imagem" id="imagem" data-holder="image-preview" class="d-none btn-imagem-preview">
								<i class="fa-light fa-image"></i> Selecionar imagem
							</label>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php echo view('Views\view_logs'); ?>
</div>

<?php echo view('Views\view_footer'); ?>
<?php echo form_close(); ?>