<?php
namespace Modules\Cad_modulos\Controllers;

use App\Controllers\BaseController;
use Modules\Cad_modulos\Models\model_cad_modulos;

class Cad_modulos extends BaseController {
	public function __construct() {
		$this->model_cad_modulos = new Model_cad_modulos;
	}

	public function index() {

		/*
		* Robots.txt
		*/

		$pathRobots = ROOTPATH . 'robots.txt';

		if (!file_exists($pathRobots)) {
			fopen($pathRobots, "w");
		}

		$dados['robots'] 			= file_get_contents($pathRobots, true);

		$dados['id']		  		= 1;
		$dados['cad_modulos'] = $this->model_cad_modulos->alterar();
		$dados['logs']		  	= $this->dataHelper->DH_getLogFile('cad_modulos', '');

		$this->dataHelper->DH_actionRecord(1);
		$this->_cms('Modules\Cad_modulos\Views\view_cad_modulos_cadastrar', $dados);
	}

	public function alterando() {
		$dados = $this->model_cad_modulos->alterar();

		/*
		* Robots.txt
		*/

		$pathRobots 	 = ROOTPATH . 'robots.txt';
		$robotsContent = service('request')->getPost('robots');

		if (!file_exists($pathRobots)) {
			fopen($pathRobots, "w");
		}

		/*
		* Arquivo verificador do Google
		*/

		if(!empty($_FILES['arquivo_verificador']) AND $_FILES['arquivo_verificador']['error'] == 0) {
			$arquivo = service('request')->getFile('arquivo_verificador');

			if(!empty($arquivo) AND ($arquivo->getSize() > 0 AND $arquivo->getSize() < 2000000) AND $arquivo->isValid() AND !$arquivo->hasMoved()) {
				$arquivo->move(ROOTPATH, $arquivo->getClientName());
				$_POST['arquivo_verificador'] = $arquivo->getClientName();

				/*
				* Altera o .htaccess
				*/

				$pathHtaccess = ROOTPATH . '.htaccess';
				$htaccess 		= file_get_contents($pathHtaccess, true);
				$htaccess 		= str_replace('RewriteCond $1 !^(', 'RewriteCond $1 !^('.str_replace('.', '\.', $arquivo->getClientName()) . '|', $htaccess);

				file_put_contents($pathHtaccess, $htaccess);
			}
		}

		file_put_contents($pathRobots, $robotsContent);
		unset($_POST['robots']);

		$this->model_cad_modulos->alterando();
		$this->dataHelper->DH_createLogFile($dados->id, $_POST, 'Alteração de cadastro', 'cad_modulos', '');
		$this->dataHelper->DH_actionRecord($dados->id);

		service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1)));
	}
}