<?php echo form_open_multipart($MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); ?>

<div class="wrapper wrapper-content animated fadeInUp">
	<?php echo view('Views\view_header'); ?>

	<?php if(isset($cad_modulos->data_cadastro) AND !empty($cad_modulos->data_cadastro)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_modulos->data_cadastro)); ?> </b>
						
						<?php if(isset($cad_modulos->data_alteracao) AND !empty($cad_modulos->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_modulos->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Formulário de cadastro
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="robots" class="form-label">
								Robots.txt:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="robots">
									<i class="fa-light fa-align-left"></i>
								</span>

								<textarea class="form-control" cols="80" rows="10" data-rule-required="true" data-msg-required="Campo obrigatório." id="robots" name="robots"><?php if(isset($robots)) { echo $robots; } ?></textarea>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Arquivo para verificação de domínio
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="arquivo" class="form-label">
								Arquivo:
							</label>

							<div class="custom-file">
								<input type="file" class="custom-file-input arquivo-replace" data-key="label-arquivo_verificador" id="arquivo_verificador" name="arquivo_verificador">
								<label class="pl-3 custom-file-label line-height-5" id="label-arquivo_verificador" for="arquivo_verificador">Selecione um arquivo</label>
							</div>
						</div>

						<?php if(!empty($cad_modulos->arquivo_verificador)) { ?>
							<div class="form-group">
								<a download href="<?php echo str_replace('painel-cms/', '', site_url($cad_modulos->arquivo_verificador)); ?>" class="btn btn-primary mt-3 w-100">
									<i class="fa-light fa-download mr-1"></i> Baixar arquivo
								</a>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php echo view('Views\view_logs'); ?>
</div>

<?php echo view('Views\view_footer'); ?>
<?php echo form_close(); ?>