<?php
namespace Modules\Cad_pixel\Controllers;

use App\Controllers\BaseController;
use Modules\Cad_pixel\Models\model_cad_pixel;
use Store\DataHelper;

class Cad_pixel extends BaseController {
	public function __construct() {
		$this->dataHelper		 	 = new DataHelper;
		$this->model_cad_pixel = new model_cad_pixel;
	}

	public function index() {
	}
	
	public function listagem() {
		$dados['cad_pixel'] = $this->model_cad_pixel->getCadastros();

		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_pixel\Views\view_cad_pixel_listar', $dados);
	}

	public function cadastrar() {
		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_pixel\Views\view_cad_pixel_cadastrar');
	}

	public function cadastrando() {
		$id = $this->model_cad_pixel->cadastrando();

		$this->dataHelper->DH_createLogFile($id, $_POST, 'Novo cadastro', 'cad_pixel', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso', 'descricao' => 'Seu cadastro foi realizado.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function alterar($id) {
		$dados['id']        = $id;
		$dados['cad_pixel'] = $this->model_cad_pixel->alterar($id);
		$dados['logs']			= $this->dataHelper->DH_getLogFile('cad_pixel', 'item_' . $id);

		$this->dataHelper->DH_actionRecord($id);
		$this->_cms('Modules\Cad_pixel\Views\view_cad_pixel_cadastrar', $dados);
	}

	public function alterando($id) {
		$this->model_cad_pixel->alterando($id);
		
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'cad_pixel', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);
		
		service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function deletar($id) {
		$dados = $this->model_cad_pixel->alterar($id);

		$this->dataHelper->DH_createLogFile($id, $dados, 'Exclusão de cadastro', 'cad_pixel', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);
		
		$this->model_cad_pixel->deletar($id);

		service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1)));
	}
}