<?php 
if(service('request')->uri->getSegment(2) == "novo-cadastro") { 
	echo form_open_multipart($MyMod . "/cadastrando", array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
else { 
	echo form_open_multipart($MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
?>

<div class="wrapper wrapper-content animated fadeInUp">
	<?php echo view('Views\view_header'); ?>

	<?php if(isset($cad_pixel->data_cadastro) AND !empty($cad_pixel->data_cadastro)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_pixel->data_cadastro)); ?> </b>
						
						<?php if(isset($cad_pixel->data_alteracao) AND !empty($cad_pixel->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_pixel->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Formulário de cadastro
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="ativo" class="form-label">
								Status:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="ativo">
									<i class="fa-light fa-power-off"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="ativo" name="ativo">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cad_pixel->ativo) and $cad_pixel->ativo == 1) { echo 'selected'; } ?> value="1">Cadastro ativo</option>
									<option <?php if(isset($cad_pixel->ativo) and $cad_pixel->ativo == 0) { echo 'selected'; } ?> value="0">Cadastro inativo</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="posicao" class="form-label">
								Posição:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="posicao">
									<i class="fa-light fa-arrows-maximize"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="posicao" name="posicao">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cad_pixel->posicao) and $cad_pixel->posicao == 'head_top') { echo 'selected'; } ?> value="head_top">Head: Parte superior</option>
									<option <?php if(isset($cad_pixel->posicao) and $cad_pixel->posicao == 'head_bottom') { echo 'selected'; } ?> value="head_bottom">Head: Parte inferior</option>
									<option <?php if(isset($cad_pixel->posicao) and $cad_pixel->posicao == 'body_top') { echo 'selected'; } ?> value="body_top">Body: Parte superior</option>
									<option <?php if(isset($cad_pixel->posicao) and $cad_pixel->posicao == 'body_bottom') { echo 'selected'; } ?> value="body_bottom">Body: Parte inferior</option>
									<option <?php if(isset($cad_pixel->posicao) and $cad_pixel->posicao == 'footer_top') { echo 'selected'; } ?> value="footer_top">Footer: Parte superior</option>
									<option <?php if(isset($cad_pixel->posicao) and $cad_pixel->posicao == 'footer_bottom') { echo 'selected'; } ?> value="footer_bottom">Footer: Parte inferior</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="titulo" class="form-label">
								Título:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="titulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="titulo" aria-describedby="titulo" data-rule-required="true" data-msg-required="Campo obrigatório." id="titulo" name="titulo" value="<?php if(isset($cad_pixel->titulo)) { echo $cad_pixel->titulo; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Formulário de cadastro
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="codigo" class="form-label">
								Código:
							</label>
							
							<div class="input-group mb-0">
								<span class="input-group-text" id="codigo">
									<i class="fa-light fa-code"></i>
								</span>
								
								<textarea class="form-control codemirror" cols="80" rows="10" data-rule-required="true" data-msg-required="Campo obrigatório." id="codigo" name="codigo"><?php if(isset($cad_pixel->codigo)) { echo $cad_pixel->codigo; } ?></textarea>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<?php echo view('Views\view_logs'); ?>
</div>

<?php echo view('Views\view_footer'); ?>
<?php echo form_close(); ?>