<?php
$routes->group(
	'cadastro-do-seo', 
	[
		'namespace' => 'Modules\Cad_seo\Controllers', 
		'filter' 		=> 'CheckAccessPermission'
	], 
	function ($routes) {
		$routes->get('/', 'Cad_seo::listagem');

		$routes->match(['get', 'post'], 'novo-cadastro', 'Cad_seo::cadastrar');
		$routes->post('cadastrando', 'Cad_seo::cadastrando');
		
		$routes->match(['get', 'post'], 'alterando-cadastro/(:any)', 'Cad_seo::alterar/$1');
		$routes->post('atualizando-cadastro/(:any)', 'Cad_seo::alterando/$1');
		
		$routes->get('deletando-cadastro/(:any)', 'Cad_seo::deletar/$1');
	}
);