<?php
namespace Modules\Cad_seo\Controllers;

use App\Controllers\BaseController;
use Modules\Cad_seo\Models\model_cad_seo;

class Cad_seo extends BaseController {
	public function __construct() {
		$this->model_cad_seo = new Model_cad_seo;
	}

	public function index() {
	}
	
	public function listagem() {
		$dados['cad_seo'] = $this->model_cad_seo->getCadastros();

		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_seo\Views\view_cad_seo_listar', $dados);
	}

	public function cadastrar() {
		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cad_seo\Views\view_cad_seo_cadastrar');
	}

	public function cadastrando() {
		$id = $this->model_cad_seo->cadastrando();
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Novo cadastro', 'cad_seo', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		if($id > 0) {
			if(isset($_FILES['imagem']) and $_FILES['imagem']['error'] == 0) {
				$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_seo', '', 'upload_cad_seo', 'item_' . $id, 'imagem', $id);
				$this->dataHelper->DH_actionRecordUpload('cad_seo', $id, $fileReturn['msg']);
			}

			service('session')->set('msg', array('titulo' => 'Sucesso', 'descricao' => 'Seu cadastro foi realizado.', 'tipo' => 'success'));
		}
		else {
			service('session')->set('msg', array('titulo' => 'Ops!', 'descricao' => 'Seu cadastro foi realizado, porém houve um problema ao salvar as imagens.', 'tipo' => 'error'));
		}

		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function alterar($id) {
		$dados['id']      = $id;
		$dados['cad_seo'] = $this->model_cad_seo->alterar($id);
		$dados['logs']		= $this->dataHelper->DH_getLogFile('cad_seo', 'item_' . $id);

		$this->dataHelper->DH_actionRecord($id);
		$this->_cms('Modules\Cad_seo\Views\view_cad_seo_cadastrar', $dados);
	}

	public function alterando($id) {
		$dados = $this->model_cad_seo->alterar($id);

		if(isset($_FILES['imagem']) and $_FILES['imagem']['error'] == 0) {
			$fileReturn = $this->uploadHelper->UPH_uploadImage('cad_seo', $dados->imagem, 'upload_cad_seo', 'item_' . $id, 'imagem', $id);
			$this->dataHelper->DH_actionRecordUpload('cad_seo', $id, $fileReturn['msg']);
		}

		if(!empty($_POST['rem_imagem'])) {
			$this->dataHelper->DH_deleteImage('cad_seo', 'imagem', 'upload_cad_seo', 'item_' . $id, $dados->imagem, $id);
		}

		unset($_POST['rem_imagem']);

		$this->model_cad_seo->alterando($id);
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'cad_seo', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function deletar($id) {
		$dados = $this->model_cad_seo->alterar($id);

		if($id > 5) {
			$this->model_cad_seo->deletar($id);
			$this->uploadHelper->UPH_deleteFolder('upload_cad_seo', $id);
			$this->dataHelper->DH_createLogFile($id, $dados, 'Exclusão de cadastro', 'cad_seo', 'item_' . $id);
			$this->dataHelper->DH_actionRecord($id);

			service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
			return redirect()->to(site_url(service('request')->uri->getSegment(1)));
		}
		else {
			service('session')->set('msg', array('titulo' => 'Ops!', 'descricao' => 'Este cadastro não pode ser removido', 'tipo' => 'error'));
			return redirect()->to(site_url(service('request')->uri->getSegment(1)));
		}
	}
}