<?php 
if(service('request')->uri->getSegment(2) == "novo-cadastro") { 
	echo form_open_multipart($MyMod . "/cadastrando", array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
else { 
	echo form_open_multipart($MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
?>

<div class="wrapper wrapper-content animated fadeInUp">
	<?php echo view('Views\view_header'); ?>

	<?php if(isset($cad_seo->data_cadastro) AND !empty($cad_seo->data_cadastro)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_seo->data_cadastro)); ?> </b>
						
						<?php if(isset($cad_seo->data_alteracao) AND !empty($cad_seo->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($cad_seo->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<?php if(service('session')->get('usuario')->id_categoria == 1) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title border-danger">
						<h5>
							Formulário de cadastro
						</h5>
					</div>

					<div class="ibox-content border-danger">
						<div class="row">
							<div class="col-12">
								<label for="url" class="form-label">
									URL:
								</label>

								<div class="input-group mb-0">
									<span class="input-group-text" id="url">
										<i class="fa-light fa-link"></i>
									</span>

									<input type="text" class="form-control" aria-label="url" aria-describedby="url" id="url" name="url" value="<?php if(isset($cad_seo->url)) { echo $cad_seo->url; } ?>">
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Textos para o SEO ( Search Engine Optimization )
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="titulo" class="form-label">
								Título:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="titulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="titulo" aria-describedby="titulo" data-rule-required="true" data-msg-required="Campo obrigatório." id="titulo" name="titulo" value="<?php if(isset($cad_seo->titulo)) { echo $cad_seo->titulo; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="subtitulo" class="form-label">
								Subtítulo:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="subtitulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="subtitulo" aria-describedby="subtitulo" data-rule-required="true" data-msg-required="Campo obrigatório." id="subtitulo" name="subtitulo" value="<?php if(isset($cad_seo->subtitulo)) { echo $cad_seo->subtitulo; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="descricao" class="form-label">
								Descrição:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="descricao">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="descricao" aria-describedby="descricao" data-rule-required="true" data-msg-required="Campo obrigatório." id="descricao" name="descricao" value="<?php if(isset($cad_seo->descricao)) { echo $cad_seo->descricao; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="autor" class="form-label">
								Autor:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="autor">
									<i class="fa-light fa-user"></i>
								</span>

								<input type="text" class="form-control" aria-label="autor" aria-describedby="autor" data-rule-required="true" data-msg-required="Campo obrigatório." id="autor" name="autor" value="<?php if(isset($cad_seo->autor)) { echo $cad_seo->autor; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="tags" class="form-label">
								Tags:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="tags">
									<i class="fa-light fa-tags"></i>
								</span>

								<input type="text" class="form-control" aria-label="tags" aria-describedby="tags" data-rule-required="true" data-msg-required="Campo obrigatório." id="tags" name="tags" value="<?php if(isset($cad_seo->tags)) { echo $cad_seo->tags; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Imagem para o SEO ( Search Engine Optimization )
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-6 border-end">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Imagem:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: Largura <b>500px</b> e altura <b>500px</b>
							</label>

							<?php if(isset($cad_seo->imagem) and $cad_seo->imagem) { ?>
								<a href="<?php echo PUBLICURL . 'uploads/upload_cad_seo/item_' . $cad_seo->id . '/' . $cad_seo->imagem; ?>" data-gallery="gallery-logos" data-title="<?php if(isset($cad_seo->titulo) and $cad_seo->titulo) { echo $cad_seo->titulo; } ?>">
									<center class="center-img">
										<img class="img-responsive" src="<?php echo PUBLICURL . 'uploads/upload_cad_seo/item_' . $cad_seo->id . '/' . $cad_seo->imagem; ?>"/>
									</center>
								</a>										
							<?php } ?>
						</div>

						<div class="col-6">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Preview:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: Largura <b>500px</b> e altura <b>500px</b>
							</label>

							<center class="center-preview-img">
								<div class="image-preview" id="imagem-seo-preview"></div>
							</center>

							<label title="Selecione a imagem." for="imagem" class="btn btn-primary w-100 mt-3">
								<input type="file" accept="image/*" name="imagem" id="imagem" data-holder="imagem-seo-preview" class="d-none btn-imagem-preview">
								<i class="fa-light fa-image"></i> Selecionar imagem
							</label>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php echo view('Views\view_logs'); ?>
</div>

<?php echo view('Views\view_footer'); ?>
<?php echo form_close(); ?>