<?php 
echo form_open_multipart($MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); 
?>

<div class="wrapper wrapper-content animated fadeInUp">
	<?php echo view('view_header'); ?>

	<?php if(isset($conf_email->data_cadastro) AND !empty($conf_email->data_cadastro)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($conf_email->data_cadastro)); ?> </b>
						
						<?php if(isset($conf_email->data_alteracao) AND !empty($conf_email->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($conf_email->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title text-light <?php if($conf_email->ativo == 0) { echo 'bg-danger'; } else { echo 'bg-primary'; } ?>">
					<?php if($conf_email->ativo == 0) { ?> 
						<b><i class="fa-light fa-triangle-exclamation mr-1"></i> Configurações não validadas!</b> O sistema não pode garantir a entrega dos e-mails.
					<?php } ?>

					<?php if($conf_email->ativo == 1) { ?> 
						<b><i class="fa-light fa-check"></i> Configurações validadas!</b> Última validação: <?php echo date("d-m-Y H:i:s", strtotime($conf_email->data_alteracao)); ?>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Configurações de conta
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="e_debug" class="form-label">
								Debug:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="e_debug">
									<i class="fa-light fa-bug"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="e_debug" name="e_debug">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($conf_email->e_debug) AND $conf_email->e_debug == '1') { echo 'selected'; } ?> value="1">Sim</option>
									<option <?php if(isset($conf_email->e_debug) AND $conf_email->e_debug == '0') { echo 'selected'; } ?> value="0">Não</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="e_host" class="form-label">
								Host:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="e_host">
									<i class="fa-light fa-server"></i>
								</span>

								<input type="text" class="form-control" aria-label="e_host" aria-describedby="e_host" data-rule-required="true" data-msg-required="Campo obrigatório." id="e_host" name="e_host" value="<?php if(isset($conf_email->e_host)) { echo $conf_email->e_host; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="e_port" class="form-label">
								Porta:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="e_port">
									<i class="fa-light fa-door-open"></i>
								</span>

								<input type="text" class="form-control" aria-label="e_port" aria-describedby="e_port" data-rule-required="true" data-msg-required="Campo obrigatório." id="e_port" name="e_port" value="<?php if(isset($conf_email->e_port)) { echo $conf_email->e_port; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="e_secure" class="form-label">
								Tipo:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="e_secure">
									<i class="fa-light fa-shield"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="e_secure" name="e_secure">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($conf_email->e_secure) AND $conf_email->e_secure == 'none') { echo 'selected'; } ?> value="none">Sem segurança</option>
									<option <?php if(isset($conf_email->e_secure) AND $conf_email->e_secure == 'ssl') { echo 'selected'; } ?> value="ssl">SSL</option>
									<option <?php if(isset($conf_email->e_secure) AND $conf_email->e_secure == 'tls') { echo 'selected'; } ?> value="tls">TLS</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="e_username" class="form-label">
								Usuário:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="e_username">
									<i class="fa-light fa-user"></i>
								</span>

								<input type="text" class="form-control" aria-label="e_username" aria-describedby="e_username" data-rule-required="true" data-msg-required="Campo obrigatório." id="e_username" name="e_username" value="<?php if(isset($conf_email->e_username)) { echo $conf_email->e_username; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="e_password" class="form-label">
								Senha:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="e_password">
									<i class="fa-light fa-key"></i>
								</span>

								<input type="text" class="form-control" aria-label="e_password" aria-describedby="e_password" data-rule-required="true" data-msg-required="Campo obrigatório." id="e_password" name="e_password" value="<?php if(isset($conf_email->e_password)) { echo $conf_email->e_password; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="e_from" class="form-label">
								E-mail de envio:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="e_from">
									<i class="fa-light fa-paper-plane-top"></i>
								</span>

								<input type="text" class="form-control" aria-label="e_from" aria-describedby="e_from" data-rule-required="true" data-msg-required="Campo obrigatório." id="e_from" name="e_from" value="<?php if(isset($conf_email->e_from)) { echo $conf_email->e_from; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="e_from_name" class="form-label">
								Identificação do e-mail de envio:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="e_from_name">
									<i class="fa-light fa-id-card"></i>
								</span>

								<input type="text" class="form-control" aria-label="e_from_name" aria-describedby="e_from_name" data-rule-required="true" data-msg-required="Campo obrigatório." id="e_from_name" name="e_from_name" value="<?php if(isset($conf_email->e_from_name)) { echo $conf_email->e_from_name; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="e_send_formulario" class="form-label">
								Enviar para:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="e_send_formulario">
									<i class="fa-light fa-paper-plane-top"></i>
								</span>

								<input type="text" class="form-control" aria-label="e_send_formulario" aria-describedby="e_send_formulario" data-rule-required="true" data-msg-required="Campo obrigatório." id="e_send_formulario" name="e_send_formulario" value="<?php if(isset($conf_email->e_send_formulario)) { echo $conf_email->e_send_formulario; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="e_send_formulario_copia" class="form-label">
								Enviar cópia para:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="e_send_formulario_copia">
									<i class="fa-light fa-paper-plane-top"></i>
								</span>

								<input type="text" class="form-control" aria-label="e_send_formulario_copia" aria-describedby="e_send_formulario_copia" id="e_send_formulario_copia" name="e_send_formulario_copia" value="<?php if(isset($conf_email->e_send_formulario_copia)) { echo $conf_email->e_send_formulario_copia; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Imagem
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-6 border-end">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Imagem:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: Largura <b>500px</b> e altura <b>500px</b>
							</label>

							<?php if(isset($conf_email->imagem) and $conf_email->imagem) { ?>
								<a href="<?php echo PUBLICURL . 'uploads/upload_conf_email/' . $conf_email->imagem; ?>" data-gallery="gallery-logos" data-title="<?php if(isset($conf_email->titulo) and $conf_email->titulo) { echo $conf_email->titulo; } ?>">
									<center class="center-img">
										<img class="img-responsive" src="<?php echo PUBLICURL . 'uploads/upload_conf_email/' . $conf_email->imagem; ?>"/>
									</center>
								</a>										
							<?php } ?>
						</div>

						<div class="col-6">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Preview:
							</label>

							<br/>

							<label class="mb-3">
								<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: Largura <b>500px</b> e altura <b>500px</b>
							</label>

							<center class="center-preview-img">
								<div class="image-preview" id="imagem-preview"></div>
							</center>

							<label title="Selecione a imagem." for="imagem" class="btn btn-primary w-100 mt-3">
								<input type="file" accept="image/*" name="imagem" id="imagem" data-holder="imagem-preview" class="d-none btn-imagem-preview">
								<i class="fa-light fa-image"></i> Selecionar imagem
							</label>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Google reCAPTCHA
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="form_login" class="form-label">
								Formulário de login:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="form_login">
									<i class="fa-light fa-gear"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="form_login" name="form_login">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($conf_email->form_login) AND $conf_email->form_login == '1') { echo 'selected'; } ?> value="1">Usar no formulário de login</option>
									<option <?php if(isset($conf_email->form_login) AND $conf_email->form_login == '0') { echo 'selected'; } ?> value="0">Não usar no formulário de login</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="form_contato" class="form-label">
								Formulário de contato:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="form_contato">
									<i class="fa-light fa-gear"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="form_contato" name="form_contato">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($conf_email->form_contato) AND $conf_email->form_contato == '1') { echo 'selected'; } ?> value="1">Usar nos formulários de contatos</option>
									<option <?php if(isset($conf_email->form_contato) AND $conf_email->form_contato == '0') { echo 'selected'; } ?> value="0">Não usar nos formulários de contato</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="e_chave_site" class="form-label">
								Chave do site:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="e_chave_site">
									<i class="fa-light fa-key"></i>
								</span>

								<input type="text" class="form-control" aria-label="e_chave_site" aria-describedby="e_chave_site" data-rule-required="true" data-msg-required="Campo obrigatório." id="e_chave_site" name="e_chave_site" value="<?php if(isset($conf_email->e_chave_site)) { echo $conf_email->e_chave_site; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="e_chave_secreta" class="form-label">
								Chave secreta:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="e_chave_secreta">
									<i class="fa-light fa-key"></i>
								</span>

								<input type="text" class="form-control" aria-label="e_chave_secreta" aria-describedby="e_chave_secreta" data-rule-required="true" data-msg-required="Campo obrigatório." id="e_chave_secreta" name="e_chave_secreta" value="<?php if(isset($conf_email->e_chave_secreta)) { echo $conf_email->e_chave_secreta; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Autenticação em dois fatores ( 2FA )
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="twofa" class="form-label">
								Status:
							</label>

							<div class="input-group mb-0">
								<label class="input-group-text" for="twofa">
									<i class="fa-light fa-power-off"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="twofa" name="twofa">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($conf_email->twofa) AND $conf_email->twofa == '1') { echo 'selected'; } ?> value="1">Sim, quero usar o 2FA</option>
									<option <?php if(isset($conf_email->twofa) AND $conf_email->twofa == '0') { echo 'selected'; } ?> value="0">Não, quero desativar o 2FA</option>
								</select>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	
	<?php echo view('Views\view_logs'); ?>
</div>

<?php echo view('Views\view_footer'); ?>
<?php echo form_close(); ?>