<?php
namespace Modules\Cms_conf_gerais\Controllers;

use App\Controllers\BaseController;
use Modules\Cms_conf_gerais\Models\model_cms_conf_gerais;
use Store\DataHelper;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

class Cms_conf_gerais extends BaseController {
	public function __construct() {
		$this->dataHelper						 = new DataHelper;
		$this->model_cms_conf_gerais = new Model_cms_conf_gerais;
	}

	public function index() {
		$dados['id']				 			= 1;
		$dados['cms_conf_gerais'] = $this->model_cms_conf_gerais->alterar();
		$dados['logs']			 			= $this->dataHelper->DH_getLogFile('cms_conf_gerais', '');

		$this->dataHelper->DH_actionRecord(1);
		$this->_cms('Modules\Cms_conf_gerais\Views\view_cms_conf_gerais_cadastrar', $dados);
	}

	public function alterando($id) {
		$dados = $this->model_cms_conf_gerais->alterar();

		$this->model_cms_conf_gerais->alterando($id);
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'cms_conf_gerais', '');
		$this->dataHelper->DH_actionRecord(1);

		service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1)));
	}
}