<?php
$routes->group(
	'cms-cadastro-de-modulos', 
	[
		'namespace' => 'Modules\Cms_modulos\Controllers', 
		'filter' 		=> 'CheckAccessPermission'
	], 
	function ($routes) {
		$routes->get('/', 'Cms_modulos::listagem');

		$routes->match(['get', 'post'], 'novo-cadastro', 'Cms_modulos::cadastrar');
		$routes->post('cadastrando', 'Cms_modulos::cadastrando');
		
		$routes->match(['get', 'post'], 'alterando-cadastro/(:any)', 'Cms_modulos::alterar/$1');
		$routes->post('atualizando-cadastro/(:any)', 'Cms_modulos::alterando/$1');
		
		$routes->get('deletando-cadastro/(:any)', 'Cms_modulos::deletar/$1');
	}
);