<?php
namespace Modules\Cms_modulos\Controllers;

use App\Controllers\BaseController;
use Modules\Cms_modulos\Models\model_cms_modulos;
use Store\DataHelper;

class Cms_modulos extends BaseController {
	public function __construct() {
		$this->dataHelper				 = new DataHelper;
		$this->model_cms_modulos = new Model_cms_modulos;
		$this->table						 = 'cms_modulos';
	}

	public function index() {
	}
	
	public function listagem() {
		$dados['table'] = $this->table;
		$dados['cms_modulos'] = $this->model_cms_modulos->getCadastros();

		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cms_modulos\Views\view_cms_modulos_listar', $dados);
	}

	public function cadastrar() {
		$dados['cms_categorias'] = $this->model_cms_modulos->getCategorias();

		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cms_modulos\Views\view_cms_modulos_cadastrar', $dados);
	}

	public function cadastrando() {
		$id = $this->model_cms_modulos->cadastrando();
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Novo cadastro', 'cms_modulos', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso', 'descricao' => 'Seu cadastro foi realizado.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function alterar($id) {
		$dados['id']          		= $id;
		$dados['cms_categorias']  = $this->model_cms_modulos->getCategorias();
		$dados['cms_modulos'] 		= $this->model_cms_modulos->alterar($id);
		$dados['logs']					 	= $this->dataHelper->DH_getLogFile('cms_modulos', 'item_' . $id);

		$this->dataHelper->DH_actionRecord($id);
		$this->_cms('Modules\Cms_modulos\Views\view_cms_modulos_cadastrar', $dados);
	}

	public function alterando($id) {
		$this->model_cms_modulos->alterando($id);
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'cms_modulos', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function deletar($id) {
		$dados = $this->model_cms_modulos->alterar($id);

		$this->model_cms_modulos->deletar($id);
		$this->dataHelper->DH_createLogFile($id, $dados, 'Exclusão de cadastro', 'cms_modulos', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1)));
	}
}