<?php
namespace Modules\Cms_modulos\Models;

use App\Models\BaseModel;

class Model_cms_modulos extends BaseModel {
	public function getCadastros() {
		$table 			= "cms_modulos";
		$builder  	= $this->db->table($table);
		
		$builder->select('cms_modulos.*, cms_modulos_categorias.titulo AS categoria');
		$builder->join('cms_modulos_categorias', 'cms_modulos_categorias.id = ' . $table . '.id_categoria', 'left');
		
		$query    	= $builder->get();

		return $query->getResult();
	}

	public function cadastrando() {
		$table 		= "cms_modulos";
		$builder  = $this->db->table($table);
		$query    = $builder->insert($_POST);

		return $this->db->insertID();
	}

	public function alterar($id) {
		$table 		= "cms_modulos";
		$builder  = $this->db->table($table)->where('cms_modulos.id', $id);
		$query    = $builder->get();

		return $query->getRow();
	}

	public function alterando($id) {
		$table 		= "cms_modulos";
		$builder  = $this->db->table($table);
		
		$builder->set('data_alteracao', date("Y-m-d H:i:s"));
		$builder->where('id', $id);
		$builder->update($_POST);

		return $id;
	}

	public function deletar($id) {
		$table 		= "cms_modulos";
		$builder  = $this->db->table($table);
		
		$builder->where('id', $id);
		$builder->delete();
	}

	public function getCategorias() {
		$table 		= "cms_modulos_categorias";
		$builder  = $this->db->table($table);
		$query    = $builder->get();

		return $query->getResult();
	}
}