<?php 
if(service('request')->uri->getSegment(2) == "novo-cadastro") { 
	echo form_open_multipart($MyMod . "/cadastrando", array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
else { 
	echo form_open_multipart($MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
?>
<div class="wrapper wrapper-content animated fadeInRight">
	<?php echo view('Views\view_header'); ?>

	<?php if(isset($cms_modulos->data_cadastro) AND !empty($cms_modulos->data_cadastro)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($cms_modulos->data_cadastro)); ?> </b>
						
						<?php if(isset($cms_modulos->data_alteracao) AND !empty($cms_modulos->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($cms_modulos->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Formulário de cadastro 
					</h5>
				</div>
				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="ativo" class="form-label">
								Status:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="ativo">
									<i class="fa-light fa-power-off"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="ativo" name="ativo">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cms_modulos->ativo) and $cms_modulos->ativo == 1) { echo 'selected'; } ?> value="1">Cadastro ativo</option>
									<option <?php if(isset($cms_modulos->ativo) and $cms_modulos->ativo == 0) { echo 'selected'; } ?> value="0">Cadastro inativo</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="thirdmenu" class="form-label">
								Third Menu:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="thirdmenu">
									<i class="fa-light fa-turn-down"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="thirdmenu" name="thirdmenu">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cms_modulos->thirdmenu) and $cms_modulos->thirdmenu == 1) { echo 'selected'; } ?> value="1">Sim</option>
									<option <?php if(isset($cms_modulos->thirdmenu) and $cms_modulos->thirdmenu == 0) { echo 'selected'; } ?> value="0">Não</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="id_categoria" class="form-label">
								Categorias:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="id_categoria">
									<i class="fa-light fa-gear"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="id_categoria" name="id_categoria">
									<option value="" disabled selected hidden></option>
									<?php foreach ($cms_categorias as $key => $valor) { ?>
										<option <?php if(isset($cms_modulos->id_categoria) AND $cms_modulos->id_categoria == $valor->id) { echo 'selected'; } ?> value="<?php echo $valor->id; ?>">
											<?php echo $valor->titulo; ?>
										</option>
									<?php } ?>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="ordem" class="form-label">
								Ordem:
							</label>
							
							<div class="input-group mb-3">
								<span class="input-group-text" id="ordem">
									<i class="fa-light fa-arrow-down-1-9"></i>
								</span>
								
								<input type="text" class="form-control" aria-label="ordem" aria-describedby="ordem" data-rule-required="true" data-msg-required="Campo obrigatório." id="ordem" name="ordem" value="<?php if(isset($cms_modulos->ordem)) { echo $cms_modulos->ordem; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="titulo" class="form-label">
								Título:
							</label>
							
							<div class="input-group mb-3">
								<span class="input-group-text" id="titulo">
									<i class="fa-light fa-align-left"></i>
								</span>
								
								<input type="text" class="form-control" aria-label="titulo" aria-describedby="titulo" data-rule-required="true" data-msg-required="Campo obrigatório." id="titulo" name="titulo" value="<?php if(isset($cms_modulos->titulo)) { echo $cms_modulos->titulo; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="url_amigavel" class="form-label">
								URL Amigável:
							</label>
							
							<div class="input-group mb-3">
								<span class="input-group-text" id="url_amigavel">
									<i class="fa-light fa-link"></i>
								</span>
								
								<input type="text" class="form-control" aria-label="url_amigavel" aria-describedby="url_amigavel" data-rule-required="true" data-msg-required="Campo obrigatório." id="url_amigavel" name="url_amigavel" value="<?php if(isset($cms_modulos->url_amigavel)) { echo $cms_modulos->url_amigavel; } ?>">
							</div>
						</div>	

						<div class="col-12">
							<label for="nome" class="form-label">
								Rota:
							</label>
							
							<div class="input-group mb-3">
								<span class="input-group-text" id="nome">
									<i class="fa-light fa-road"></i>
								</span>
								
								<input type="text" class="form-control" aria-label="nome" aria-describedby="nome" data-rule-required="true" data-msg-required="Campo obrigatório." id="nome" name="nome" value="<?php if(isset($cms_modulos->nome)) { echo $cms_modulos->nome; } ?>">
							</div>
						</div>	

						<div class="col-12">
							<label for="icone" class="form-label">
								Ícone:
							</label>
							
							<div class="input-group mb-3">
								<span class="input-group-text" id="icone">
									<i class="fa-light fa-icons"></i>
								</span>
								
								<input type="text" class="form-control" aria-label="icone" aria-describedby="icone" data-rule-required="true" data-msg-required="Campo obrigatório." id="icone" name="icone" value="<?php if(isset($cms_modulos->icone)) { echo $cms_modulos->icone; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="dashboard" class="form-label">
								Dashboard:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="dashboard">
									<i class="fa-light fa-table-columns"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="dashboard" name="dashboard">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cms_modulos->dashboard) and $cms_modulos->dashboard == 1) { echo 'selected'; } ?> value="1">Mostrar card no dashboard</option>
									<option <?php if(isset($cms_modulos->dashboard) and $cms_modulos->dashboard == 0) { echo 'selected'; } ?> value="0">Não mostrar card no dashboard</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="card" class="form-label">
								Título do card (dashboard):
							</label>
							
							<div class="input-group mb-3">
								<span class="input-group-text" id="card">
									<i class="fa-thin fa-cards-blank"></i>
								</span>
								
								<input type="text" class="form-control" aria-label="card" aria-describedby="card" id="card" name="card" value="<?php if(isset($cms_modulos->card)) { echo $cms_modulos->card; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="root" class="form-label">
								Acesso <span class="text-danger">ROOT</span>:
							</label>

							<div class="input-group mb-0">
								<label class="input-group-text" for="root">
									<i class="fa-light fa-user-secret"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="root" name="root">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cms_modulos->root) and $cms_modulos->root == 1) { echo 'selected'; } ?> value="1">Sim, este módulo é acessado apenas pelo ROOT</option>
									<option <?php if(isset($cms_modulos->root) and $cms_modulos->root == 0) { echo 'selected'; } ?> value="0">Não, este módulo é de acesso público</option>
								</select>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Permissões
					</h5>
				</div>

				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="cadastrar" class="form-label">
								Cadastrar:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="cadastrar">
									<i class="fa-light fa-plus"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="cadastrar" name="cadastrar">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cms_modulos->cadastrar) and $cms_modulos->cadastrar == 1) { echo 'selected'; } ?> value="1">É permitido cadastrar</option>
									<option <?php if(isset($cms_modulos->cadastrar) and $cms_modulos->cadastrar == 0) { echo 'selected'; } ?> value="0">Não e permitido cadastrar</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="editar" class="form-label">
								Editar:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="editar">
									<i class="fa-light fa-pen-to-square"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="editar" name="editar">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cms_modulos->editar) and $cms_modulos->editar == 1) { echo 'selected'; } ?> value="1">É permitido editar</option>
									<option <?php if(isset($cms_modulos->editar) and $cms_modulos->editar == 0) { echo 'selected'; } ?> value="0">Não e permitido editar</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="excluir" class="form-label">
								Excluir:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="excluir">
									<i class="fa-light fa-trash"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="excluir" name="excluir">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cms_modulos->excluir) and $cms_modulos->excluir == 1) { echo 'selected'; } ?> value="1">É permitido excluir</option>
									<option <?php if(isset($cms_modulos->excluir) and $cms_modulos->excluir == 0) { echo 'selected'; } ?> value="0">Não e permitido excluir</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="salvar" class="form-label">
								Salvar:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="salvar">
									<i class="fa-light fa-floppy-disk"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="salvar" name="salvar">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cms_modulos->salvar) and $cms_modulos->salvar == 1) { echo 'selected'; } ?> value="1">É permitido salvar</option>
									<option <?php if(isset($cms_modulos->salvar) and $cms_modulos->salvar == 0) { echo 'selected'; } ?> value="0">Não e permitido salvar</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="upload" class="form-label">
								Upload:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="upload">
									<i class="fa-light fa-upload"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="upload" name="upload">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cms_modulos->upload) and $cms_modulos->upload == 1) { echo 'selected'; } ?> value="1">É permitido upload</option>
									<option <?php if(isset($cms_modulos->upload) and $cms_modulos->upload == 0) { echo 'selected'; } ?> value="0">Não e permitido upload</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="lote" class="form-label">
								Ação em lote:
							</label>

							<div class="input-group mb-0">
								<label class="input-group-text" for="lote">
									<i class="fa-light fa-ballot"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="lote" name="lote">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cms_modulos->lote) and $cms_modulos->lote == 1) { echo 'selected'; } ?> value="1">É permitido executar ações em lote</option>
									<option <?php if(isset($cms_modulos->lote) and $cms_modulos->lote == 0) { echo 'selected'; } ?> value="0">Não e permitido executar ações em lote</option>
								</select>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php echo view('Views\view_logs'); ?>
</div>

<?php echo view('Views\view_footer'); ?>
<?php echo form_close(); ?>