<?php
namespace Modules\Cms_modulos_categorias\Controllers;

use App\Controllers\BaseController;
use Modules\Cms_modulos_categorias\Models\model_cms_modulos_categorias;
use Store\DataHelper;

class Cms_modulos_categorias extends BaseController {
	public function __construct() {
		$this->dataHelper				 						= new DataHelper;
		$this->model_cms_modulos_categorias 					= new Model_cms_modulos_categorias;
		$this->table 											= 'cms_modulos_categorias';
	}

	public function index() {
	}
	
	public function listagem() {
		$dados['table'] 										= $this->table;
		$dados['cms_modulos_categorias'] = $this->model_cms_modulos_categorias->getCadastros();

		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cms_modulos_categorias\Views\view_cms_modulos_categorias_listar', $dados);
	}

	public function cadastrar() {
		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cms_modulos_categorias\Views\view_cms_modulos_categorias_cadastrar');
	}

	public function cadastrando() {
		$id = $this->model_cms_modulos_categorias->cadastrando();
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Novo cadastro', 'model_cms_modulos_categorias', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso', 'descricao' => 'Seu cadastro foi realizado.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function alterar($id) {
		$dados['id']        						 = $id;
		$dados['cms_modulos_categorias'] = $this->model_cms_modulos_categorias->alterar($id);
		$dados['logs']					 				 = $this->dataHelper->DH_getLogFile('model_cms_modulos_categorias', 'item_' . $id);

		$this->dataHelper->DH_actionRecord($id);
		$this->_cms('Modules\Cms_modulos_categorias\Views\view_cms_modulos_categorias_cadastrar', $dados);
	}

	public function alterando($id) {
		$this->model_cms_modulos_categorias->alterando($id);
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'model_cms_modulos_categorias', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function deletar($id) {
		$dados = $this->model_model_cms_modulos_categorias->alterar($id);

		$this->model_cms_modulos_categorias->deletar($id);
		$this->dataHelper->DH_createLogFile($id, $dados, 'Exclusão de cadastro', 'model_cms_modulos_categorias', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1)));
	}
}