<?php 
if(service('request')->uri->getSegment(2) == "novo-cadastro") { 
	echo form_open_multipart($MyMod . "/cadastrando", array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
else { 
	echo form_open_multipart($MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
?>

<div class="wrapper wrapper-content animated fadeInRight">
	<?php echo view('Views\view_header'); ?>

	<?php if(isset($cms_modulos_categorias->data_cadastro) AND !empty($cms_modulos_categorias->data_cadastro)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($cms_modulos_categorias->data_cadastro)); ?> </b>
						
						<?php if(isset($cms_modulos_categorias->data_alteracao) AND !empty($cms_modulos_categorias->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($cms_modulos_categorias->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title">
					<h5>
						Formulário de cadastro
					</h5>
				</div>
				
				<div class="ibox-content">
					<div class="row">
						<div class="col-12">
							<label for="ativo" class="form-label">
								Status:
							</label>
							
							<div class="input-group mb-3">
								<label class="input-group-text" for="ativo">
									<i class="fa-light fa-power-off"></i>
								</label>
								
								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="ativo" name="ativo">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cms_modulos_categorias->ativo) and $cms_modulos_categorias->ativo == 1) { echo 'selected'; } ?> value="1">Cadastro ativo</option>
									<option <?php if(isset($cms_modulos_categorias->ativo) and $cms_modulos_categorias->ativo == 0) { echo 'selected'; } ?> value="0">Cadastro inativo</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="titulo" class="form-label">
								Título:
							</label>
							
							<div class="input-group mb-3">
								<span class="input-group-text" id="titulo">
									<i class="fa-light fa-align-left"></i>
								</span>
								
								<input type="text" class="form-control" aria-label="titulo" aria-describedby="titulo" data-rule-required="true" data-msg-required="Campo obrigatório." id="titulo" name="titulo" value="<?php if(isset($cms_modulos_categorias->titulo)) { echo $cms_modulos_categorias->titulo; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="nome" class="form-label">
								Rota:
							</label>
							
							<div class="input-group mb-3">
								<span class="input-group-text" id="nome">
									<i class="fa-light fa-road"></i>
								</span>
								
								<input type="text" class="form-control" aria-label="nome" aria-describedby="nome" data-rule-required="true" data-msg-required="Campo obrigatório." id="nome" name="nome" value="<?php if(isset($cms_modulos_categorias->nome)) { echo $cms_modulos_categorias->nome; } ?>">
							</div>
						</div>
						
						<div class="col-12">
							<label for="url_amigavel" class="form-label">
								URL Amigável:
							</label>
							
							<div class="input-group mb-3">
								<span class="input-group-text" id="url_amigavel">
									<i class="fa-light fa-link"></i>
								</span>
								
								<input type="text" class="form-control" aria-label="url_amigavel" aria-describedby="url_amigavel" data-rule-required="true" data-msg-required="Campo obrigatório." id="url_amigavel" name="url_amigavel" value="<?php if(isset($cms_modulos_categorias->url_amigavel)) { echo $cms_modulos_categorias->url_amigavel; } ?>">
							</div>
						</div>
						
						<div class="col-12">
							<label for="icone" class="form-label">
								Ícone:
							</label>
							
							<div class="input-group mb-3">
								<span class="input-group-text" id="icone">
									<i class="fa-light fa-icons"></i>
								</span>
								
								<input type="text" class="form-control" aria-label="icone" aria-describedby="icone" data-rule-required="true" data-msg-required="Campo obrigatório." id="icone" name="icone" value="<?php if(isset($cms_modulos_categorias->icone)) { echo $cms_modulos_categorias->icone; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="ordem" class="form-label">
								Ordem:
							</label>
							
							<div class="input-group mb-3">
								<span class="input-group-text" id="ordem">
									<i class="fa-light fa-arrow-down-1-9"></i>
								</span>
								
								<input type="text" class="form-control" aria-label="ordem" aria-describedby="ordem" data-rule-required="true" data-msg-required="Campo obrigatório." id="ordem" name="ordem" value="<?php if(isset($cms_modulos_categorias->ordem)) { echo $cms_modulos_categorias->ordem; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="root" class="form-label">
								Acesso ROOT:
							</label>
							
							<div class="input-group mb-0">
								<span class="input-group-text" id="root">
									<i class="fa-light fa-user-secret"></i>
								</span>
								
								<input type="text" class="form-control" aria-label="root" aria-describedby="root" data-rule-required="true" data-msg-required="Campo obrigatório." id="root" name="root" value="<?php if(isset($cms_modulos_categorias->root)) { echo $cms_modulos_categorias->root; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="api" class="form-label">
								ID da API:
							</label>
							
							<div class="input-group mb-0">
								<span class="input-group-text" id="api">
									<i class="fa-light fa-user-secret"></i>
								</span>
								
								<input type="text" class="form-control" aria-label="api" aria-describedby="api" data-rule-required="true" data-msg-required="Campo obrigatório." id="api" name="api" value="<?php if(isset($cms_modulos_categorias->api)) { echo $cms_modulos_categorias->api; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php echo view('Views\view_logs'); ?>
</div>

<?php echo view('Views\view_footer'); ?>
<?php echo form_close(); ?>