<?php
namespace Modules\Cms_plataformas\Controllers;

use App\Controllers\BaseController;
use Modules\Cms_plataformas\Models\model_cms_plataformas;
use Store\DataHelper;

class Cms_plataformas extends BaseController {
	public function __construct() {
		$this->dataHelper						 = new DataHelper;
		$this->model_cms_plataformas = new Model_cms_plataformas;
	}

	public function index() {
	}
	
	public function listagem() {
		$dados['cms_plataformas'] = $this->model_cms_plataformas->getCadastros();

		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cms_plataformas\Views\view_cms_plataformas_listar', $dados);
	}

	public function cadastrar() {
		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cms_plataformas\Views\view_cms_plataformas_cadastrar');
	}

	public function cadastrando() {
    $id = $this->model_cms_plataformas->cadastrando();
    $this->dataHelper->DH_createLogFile($id, $_POST, 'Novo cadastro', 'cms_plataformas', 'item_' . $id);
    $this->dataHelper->DH_actionRecord($id);

    if($id > 0) {
    	if(isset($_FILES['imagem']) and $_FILES['imagem']['error'] == 0) {
    		$fileReturn = $this->uploadHelper->UPH_uploadImage('cms_plataformas', '', 'upload_cms_plataformas', 'item_' . $id, 'imagem', $id);
    		$this->dataHelper->DH_actionRecordUpload('cms_plataformas', $id, $fileReturn['msg']);
    	}

    	service('session')->set('msg', array('titulo' => 'Sucesso', 'descricao' => 'Seu cadastro foi realizado.', 'tipo' => 'success'));
    }
    else {
    	service('session')->set('msg', array('titulo' => 'Ops!', 'descricao' => 'Seu cadastro foi realizado, porém houve um problema ao salvar as imagens.', 'tipo' => 'error'));
    }

    return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
  }

  public function alterar($id) {
  	$dados['id']             	= $id;
  	$dados['cms_plataformas'] = $this->model_cms_plataformas->alterar($id);
  	$dados['logs']					 	= $this->dataHelper->DH_getLogFile('cms_plataformas', 'item_' . $id);

  	$this->dataHelper->DH_actionRecord($id);
  	$this->_cms('Modules\Cms_plataformas\Views\view_cms_plataformas_cadastrar', $dados);
  }

  public function alterando($id) {
    $dados = $this->model_cms_plataformas->alterar($id);

    if(isset($_FILES['imagem']) and $_FILES['imagem']['error'] == 0) {
    	$fileReturn = $this->uploadHelper->UPH_uploadImage('cms_plataformas', $dados->imagem, 'upload_cms_plataformas', 'item_' . $id, 'imagem', $id);
    	$this->dataHelper->DH_actionRecordUpload('cms_plataformas', $id, $fileReturn['msg']);
    }

    if(!empty($_POST['rem_imagem'])) {
    	$this->dataHelper->DH_deleteImage('cms_plataformas', 'imagem', 'upload_cms_plataformas', 'item_' . $id, $dados->imagem, $id);
    }

    unset($_POST['rem_imagem']);

    $this->model_cms_plataformas->alterando($id);
    $this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'cms_plataformas', 'item_' . $id);
    $this->dataHelper->DH_actionRecord($id);

    service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
    return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
  }

  public function deletar($id) {
  	$dados = $this->model_cms_plataformas->alterar($id);

  	$this->dataHelper->DH_createLogFile($id, $dados, 'Exclusão de cadastro', 'cms_plataformas', 'item_' . $id);
  	$this->uploadHelper->UPH_deleteFolder('upload_cms_plataformas', $id);
  	$this->dataHelper->DH_actionRecord($id);
  	
  	$this->model_cms_plataformas->deletar($id);

  	service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
  	return redirect()->to(site_url(service('request')->uri->getSegment(1)));
  }
}